<?php

namespace EnumType;

/**
 * This class stands for businessTypeEnum EnumType
 * @subpackage Enumerations
 */
class BusinessTypeEnum
{
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Constant for value 'CONSUMER'
     * @return string 'CONSUMER'
     */
    const VALUE_CONSUMER = 'CONSUMER';
    /**
     * Constant for value 'BUSINESS'
     * @return string 'BUSINESS'
     */
    const VALUE_BUSINESS = 'BUSINESS';
    /**
     * Constant for value 'SCRATCH_CARD'
     * @return string 'SCRATCH_CARD'
     */
    const VALUE_SCRATCH_CARD = 'SCRATCH_CARD';
    /**
     * Constant for value 'SHARING_GROUP'
     * @return string 'SHARING_GROUP'
     */
    const VALUE_SHARING_GROUP = 'SHARING_GROUP';
    /**
     * Constant for value 'OP'
     * @return string 'OP'
     */
    const VALUE_OP = 'OP';
    /**
     * Constant for value 'SBD'
     * @return string 'SBD'
     */
    const VALUE_SBD = 'SBD';
    /**
     * Constant for value 'BURSTSERVICE'
     * @return string 'BURSTSERVICE'
     */
    const VALUE_BURSTSERVICE = 'BURSTSERVICE';
    /**
     * Constant for value 'M2M'
     * @return string 'M2M'
     */
    const VALUE_M_2_M = 'M2M';
    /**
     * Constant for value 'PAGING'
     * @return string 'PAGING'
     */
    const VALUE_PAGING = 'PAGING';
    /**
     * Constant for value 'TEL'
     * @return string 'TEL'
     */
    const VALUE_TEL = 'TEL';
    /**
     * Constant for value 'PTT_TG'
     * @return string 'PTT_TG'
     */
    const VALUE_PTT_TG = 'PTT_TG';
    /**
     * Constant for value 'CERTUS'
     * @return string 'CERTUS'
     */
    const VALUE_CERTUS = 'CERTUS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_CONSUMER
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_SCRATCH_CARD
     * @uses self::VALUE_SHARING_GROUP
     * @uses self::VALUE_OP
     * @uses self::VALUE_SBD
     * @uses self::VALUE_BURSTSERVICE
     * @uses self::VALUE_M_2_M
     * @uses self::VALUE_PAGING
     * @uses self::VALUE_TEL
     * @uses self::VALUE_PTT_TG
     * @uses self::VALUE_CERTUS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_CONSUMER,
            self::VALUE_BUSINESS,
            self::VALUE_SCRATCH_CARD,
            self::VALUE_SHARING_GROUP,
            self::VALUE_OP,
            self::VALUE_SBD,
            self::VALUE_BURSTSERVICE,
            self::VALUE_M_2_M,
            self::VALUE_PAGING,
            self::VALUE_TEL,
            self::VALUE_PTT_TG,
            self::VALUE_CERTUS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
