<?php

namespace EnumType;

/**
 * This class stands for accountStatusEnum EnumType
 * @subpackage Enumerations
 */
class AccountStatusEnum
{
    /**
     * Constant for value 'ACTIVE'
     * @return string 'ACTIVE'
     */
    const VALUE_ACTIVE = 'ACTIVE';
    /**
     * Constant for value 'PENDING'
     * @return string 'PENDING'
     */
    const VALUE_PENDING = 'PENDING';
    /**
     * Constant for value 'SUSPENDED'
     * @return string 'SUSPENDED'
     */
    const VALUE_SUSPENDED = 'SUSPENDED';
    /**
     * Constant for value 'DEACTIVE'
     * @return string 'DEACTIVE'
     */
    const VALUE_DEACTIVE = 'DEACTIVE';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'INCOMPLETE'
     * @return string 'INCOMPLETE'
     */
    const VALUE_INCOMPLETE = 'INCOMPLETE';
    /**
     * Constant for value 'PREPAID_ERROR'
     * @return string 'PREPAID_ERROR'
     */
    const VALUE_PREPAID_ERROR = 'PREPAID_ERROR';
    /**
     * Constant for value 'REQUESTED'
     * @return string 'REQUESTED'
     */
    const VALUE_REQUESTED = 'REQUESTED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACTIVE
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_SUSPENDED
     * @uses self::VALUE_DEACTIVE
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_INCOMPLETE
     * @uses self::VALUE_PREPAID_ERROR
     * @uses self::VALUE_REQUESTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACTIVE,
            self::VALUE_PENDING,
            self::VALUE_SUSPENDED,
            self::VALUE_DEACTIVE,
            self::VALUE_ERROR,
            self::VALUE_INCOMPLETE,
            self::VALUE_PREPAID_ERROR,
            self::VALUE_REQUESTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
