<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for voucherOrderImpl StructType
 * @subpackage Structs
 */
class VoucherOrderImpl extends AbstractStructBase
{
    /**
     * The purchaseOrder
     * @var string
     */
    public $purchaseOrder;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The createDate
     * @var string
     */
    public $createDate;
    /**
     * The lineItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\LineItems
     */
    public $lineItems;
    /**
     * The batches
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Batches
     */
    public $batches;
    /**
     * The createdBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createdBy;
    /**
     * Constructor method for voucherOrderImpl
     * @uses VoucherOrderImpl::setPurchaseOrder()
     * @uses VoucherOrderImpl::setDescription()
     * @uses VoucherOrderImpl::setCreateDate()
     * @uses VoucherOrderImpl::setLineItems()
     * @uses VoucherOrderImpl::setBatches()
     * @uses VoucherOrderImpl::setCreatedBy()
     * @param string $purchaseOrder
     * @param string $description
     * @param string $createDate
     * @param \StructType\LineItems $lineItems
     * @param \StructType\Batches $batches
     * @param string $createdBy
     */
    public function __construct($purchaseOrder = null, $description = null, $createDate = null, \StructType\LineItems $lineItems = null, \StructType\Batches $batches = null, $createdBy = null)
    {
        $this
            ->setPurchaseOrder($purchaseOrder)
            ->setDescription($description)
            ->setCreateDate($createDate)
            ->setLineItems($lineItems)
            ->setBatches($batches)
            ->setCreatedBy($createdBy);
    }
    /**
     * Get purchaseOrder value
     * @return string|null
     */
    public function getPurchaseOrder()
    {
        return $this->purchaseOrder;
    }
    /**
     * Set purchaseOrder value
     * @param string $purchaseOrder
     * @return \StructType\VoucherOrderImpl
     */
    public function setPurchaseOrder($purchaseOrder = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseOrder) && !is_string($purchaseOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purchaseOrder)), __LINE__);
        }
        $this->purchaseOrder = $purchaseOrder;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\VoucherOrderImpl
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\VoucherOrderImpl
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get lineItems value
     * @return \StructType\LineItems|null
     */
    public function getLineItems()
    {
        return $this->lineItems;
    }
    /**
     * Set lineItems value
     * @param \StructType\LineItems $lineItems
     * @return \StructType\VoucherOrderImpl
     */
    public function setLineItems(\StructType\LineItems $lineItems = null)
    {
        $this->lineItems = $lineItems;
        return $this;
    }
    /**
     * Get batches value
     * @return \StructType\Batches|null
     */
    public function getBatches()
    {
        return $this->batches;
    }
    /**
     * Set batches value
     * @param \StructType\Batches $batches
     * @return \StructType\VoucherOrderImpl
     */
    public function setBatches(\StructType\Batches $batches = null)
    {
        $this->batches = $batches;
        return $this;
    }
    /**
     * Get createdBy value
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->createdBy;
    }
    /**
     * Set createdBy value
     * @param string $createdBy
     * @return \StructType\VoucherOrderImpl
     */
    public function setCreatedBy($createdBy = null)
    {
        // validation for constraint: string
        if (!is_null($createdBy) && !is_string($createdBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdBy)), __LINE__);
        }
        $this->createdBy = $createdBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VoucherOrderImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
