<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for verticals StructType
 * @subpackage Structs
 */
class Verticals extends AbstractStructBase
{
    /**
     * The vertical
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VerticalImpl[]
     */
    public $vertical;
    /**
     * Constructor method for verticals
     * @uses Verticals::setVertical()
     * @param \StructType\VerticalImpl[] $vertical
     */
    public function __construct(array $vertical = array())
    {
        $this
            ->setVertical($vertical);
    }
    /**
     * Get vertical value
     * @return \StructType\VerticalImpl[]|null
     */
    public function getVertical()
    {
        return $this->vertical;
    }
    /**
     * Set vertical value
     * @throws \InvalidArgumentException
     * @param \StructType\VerticalImpl[] $vertical
     * @return \StructType\Verticals
     */
    public function setVertical(array $vertical = array())
    {
        foreach ($vertical as $verticalsVerticalItem) {
            // validation for constraint: itemType
            if (!$verticalsVerticalItem instanceof \StructType\VerticalImpl) {
                throw new \InvalidArgumentException(sprintf('The vertical property can only contain items of \StructType\VerticalImpl, "%s" given', is_object($verticalsVerticalItem) ? get_class($verticalsVerticalItem) : gettype($verticalsVerticalItem)), __LINE__);
            }
        }
        $this->vertical = $vertical;
        return $this;
    }
    /**
     * Add item to vertical value
     * @throws \InvalidArgumentException
     * @param \StructType\VerticalImpl $item
     * @return \StructType\Verticals
     */
    public function addToVertical(\StructType\VerticalImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VerticalImpl) {
            throw new \InvalidArgumentException(sprintf('The vertical property can only contain items of \StructType\VerticalImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vertical[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Verticals
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
