<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for validateDeviceStringRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:validateDeviceStringRequestImpl
 * @subpackage Structs
 */
class ValidateDeviceStringRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The deviceString
     * @var string
     */
    public $deviceString;
    /**
     * The deviceStringType
     * @var string
     */
    public $deviceStringType;
    /**
     * The fromDeviceString
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromDeviceString;
    /**
     * The validateState
     * Meta informations extracted from the WSDL
     * - default: true
     * - minOccurs: 0
     * @var bool
     */
    public $validateState;
    /**
     * The fromSubmarket
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fromSubmarket;
    /**
     * Constructor method for validateDeviceStringRequestImpl
     * @uses ValidateDeviceStringRequestImpl::setServiceType()
     * @uses ValidateDeviceStringRequestImpl::setDeviceString()
     * @uses ValidateDeviceStringRequestImpl::setDeviceStringType()
     * @uses ValidateDeviceStringRequestImpl::setFromDeviceString()
     * @uses ValidateDeviceStringRequestImpl::setValidateState()
     * @uses ValidateDeviceStringRequestImpl::setFromSubmarket()
     * @param string $serviceType
     * @param string $deviceString
     * @param string $deviceStringType
     * @param string $fromDeviceString
     * @param bool $validateState
     * @param string $fromSubmarket
     */
    public function __construct($serviceType = null, $deviceString = null, $deviceStringType = null, $fromDeviceString = null, $validateState = true, $fromSubmarket = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setDeviceString($deviceString)
            ->setDeviceStringType($deviceStringType)
            ->setFromDeviceString($fromDeviceString)
            ->setValidateState($validateState)
            ->setFromSubmarket($fromSubmarket);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get deviceString value
     * @return string|null
     */
    public function getDeviceString()
    {
        return $this->deviceString;
    }
    /**
     * Set deviceString value
     * @param string $deviceString
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setDeviceString($deviceString = null)
    {
        // validation for constraint: string
        if (!is_null($deviceString) && !is_string($deviceString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceString)), __LINE__);
        }
        $this->deviceString = $deviceString;
        return $this;
    }
    /**
     * Get deviceStringType value
     * @return string|null
     */
    public function getDeviceStringType()
    {
        return $this->deviceStringType;
    }
    /**
     * Set deviceStringType value
     * @uses \EnumType\DeviceStringTypeEnum::valueIsValid()
     * @uses \EnumType\DeviceStringTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceStringType
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setDeviceStringType($deviceStringType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceStringTypeEnum::valueIsValid($deviceStringType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceStringType, implode(', ', \EnumType\DeviceStringTypeEnum::getValidValues())), __LINE__);
        }
        $this->deviceStringType = $deviceStringType;
        return $this;
    }
    /**
     * Get fromDeviceString value
     * @return string|null
     */
    public function getFromDeviceString()
    {
        return $this->fromDeviceString;
    }
    /**
     * Set fromDeviceString value
     * @param string $fromDeviceString
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setFromDeviceString($fromDeviceString = null)
    {
        // validation for constraint: string
        if (!is_null($fromDeviceString) && !is_string($fromDeviceString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromDeviceString)), __LINE__);
        }
        $this->fromDeviceString = $fromDeviceString;
        return $this;
    }
    /**
     * Get validateState value
     * @return bool|null
     */
    public function getValidateState()
    {
        return $this->validateState;
    }
    /**
     * Set validateState value
     * @param bool $validateState
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setValidateState($validateState = true)
    {
        $this->validateState = $validateState;
        return $this;
    }
    /**
     * Get fromSubmarket value
     * @return string|null
     */
    public function getFromSubmarket()
    {
        return $this->fromSubmarket;
    }
    /**
     * Set fromSubmarket value
     * @param string $fromSubmarket
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public function setFromSubmarket($fromSubmarket = null)
    {
        // validation for constraint: string
        if (!is_null($fromSubmarket) && !is_string($fromSubmarket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromSubmarket)), __LINE__);
        }
        $this->fromSubmarket = $fromSubmarket;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateDeviceStringRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
