<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for userImpl StructType
 * @subpackage Structs
 */
class UserImpl extends AbstractStructBase
{
    /**
     * The allAccessInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AllAccessInfo
     */
    public $allAccessInfo;
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The contactInfo
     * @var \StructType\ContactInfoImpl
     */
    public $contactInfo;
    /**
     * The passwordExpiry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $passwordExpiry;
    /**
     * Constructor method for userImpl
     * @uses UserImpl::setAllAccessInfo()
     * @uses UserImpl::setUsername()
     * @uses UserImpl::setPassword()
     * @uses UserImpl::setStatus()
     * @uses UserImpl::setContactInfo()
     * @uses UserImpl::setPasswordExpiry()
     * @param \StructType\AllAccessInfo $allAccessInfo
     * @param string $username
     * @param string $password
     * @param string $status
     * @param \StructType\ContactInfoImpl $contactInfo
     * @param string $passwordExpiry
     */
    public function __construct(\StructType\AllAccessInfo $allAccessInfo = null, $username = null, $password = null, $status = null, \StructType\ContactInfoImpl $contactInfo = null, $passwordExpiry = null)
    {
        $this
            ->setAllAccessInfo($allAccessInfo)
            ->setUsername($username)
            ->setPassword($password)
            ->setStatus($status)
            ->setContactInfo($contactInfo)
            ->setPasswordExpiry($passwordExpiry);
    }
    /**
     * Get allAccessInfo value
     * @return \StructType\AllAccessInfo|null
     */
    public function getAllAccessInfo()
    {
        return $this->allAccessInfo;
    }
    /**
     * Set allAccessInfo value
     * @param \StructType\AllAccessInfo $allAccessInfo
     * @return \StructType\UserImpl
     */
    public function setAllAccessInfo(\StructType\AllAccessInfo $allAccessInfo = null)
    {
        $this->allAccessInfo = $allAccessInfo;
        return $this;
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\UserImpl
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\UserImpl
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\UserStatusEnum::valueIsValid()
     * @uses \EnumType\UserStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\UserImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\UserStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get contactInfo value
     * @return \StructType\ContactInfoImpl|null
     */
    public function getContactInfo()
    {
        return $this->contactInfo;
    }
    /**
     * Set contactInfo value
     * @param \StructType\ContactInfoImpl $contactInfo
     * @return \StructType\UserImpl
     */
    public function setContactInfo(\StructType\ContactInfoImpl $contactInfo = null)
    {
        $this->contactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get passwordExpiry value
     * @return string|null
     */
    public function getPasswordExpiry()
    {
        return $this->passwordExpiry;
    }
    /**
     * Set passwordExpiry value
     * @param string $passwordExpiry
     * @return \StructType\UserImpl
     */
    public function setPasswordExpiry($passwordExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($passwordExpiry) && !is_string($passwordExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passwordExpiry)), __LINE__);
        }
        $this->passwordExpiry = $passwordExpiry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
