<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateUserProfileRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:updateUserProfileRequestImpl
 * @subpackage Structs
 */
class UpdateUserProfileRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The currentUsername
     * @var string
     */
    public $currentUsername;
    /**
     * The newUser
     * @var \StructType\UserImpl
     */
    public $newUser;
    /**
     * The resetPasswd
     * @var bool
     */
    public $resetPasswd;
    /**
     * Constructor method for updateUserProfileRequestImpl
     * @uses UpdateUserProfileRequestImpl::setCurrentUsername()
     * @uses UpdateUserProfileRequestImpl::setNewUser()
     * @uses UpdateUserProfileRequestImpl::setResetPasswd()
     * @param string $currentUsername
     * @param \StructType\UserImpl $newUser
     * @param bool $resetPasswd
     */
    public function __construct($currentUsername = null, \StructType\UserImpl $newUser = null, $resetPasswd = null)
    {
        $this
            ->setCurrentUsername($currentUsername)
            ->setNewUser($newUser)
            ->setResetPasswd($resetPasswd);
    }
    /**
     * Get currentUsername value
     * @return string|null
     */
    public function getCurrentUsername()
    {
        return $this->currentUsername;
    }
    /**
     * Set currentUsername value
     * @param string $currentUsername
     * @return \StructType\UpdateUserProfileRequestImpl
     */
    public function setCurrentUsername($currentUsername = null)
    {
        // validation for constraint: string
        if (!is_null($currentUsername) && !is_string($currentUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentUsername)), __LINE__);
        }
        $this->currentUsername = $currentUsername;
        return $this;
    }
    /**
     * Get newUser value
     * @return \StructType\UserImpl|null
     */
    public function getNewUser()
    {
        return $this->newUser;
    }
    /**
     * Set newUser value
     * @param \StructType\UserImpl $newUser
     * @return \StructType\UpdateUserProfileRequestImpl
     */
    public function setNewUser(\StructType\UserImpl $newUser = null)
    {
        $this->newUser = $newUser;
        return $this;
    }
    /**
     * Get resetPasswd value
     * @return bool|null
     */
    public function getResetPasswd()
    {
        return $this->resetPasswd;
    }
    /**
     * Set resetPasswd value
     * @param bool $resetPasswd
     * @return \StructType\UpdateUserProfileRequestImpl
     */
    public function setResetPasswd($resetPasswd = null)
    {
        $this->resetPasswd = $resetPasswd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateUserProfileRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
