<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transactions StructType
 * @subpackage Structs
 */
class Transactions extends AbstractStructBase
{
    /**
     * The transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\TransactionHistoryReportImpl[]
     */
    public $transaction;
    /**
     * Constructor method for transactions
     * @uses Transactions::setTransaction()
     * @param \StructType\TransactionHistoryReportImpl[] $transaction
     */
    public function __construct(array $transaction = array())
    {
        $this
            ->setTransaction($transaction);
    }
    /**
     * Get transaction value
     * @return \StructType\TransactionHistoryReportImpl[]|null
     */
    public function getTransaction()
    {
        return $this->transaction;
    }
    /**
     * Set transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionHistoryReportImpl[] $transaction
     * @return \StructType\Transactions
     */
    public function setTransaction(array $transaction = array())
    {
        foreach ($transaction as $transactionsTransactionItem) {
            // validation for constraint: itemType
            if (!$transactionsTransactionItem instanceof \StructType\TransactionHistoryReportImpl) {
                throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionHistoryReportImpl, "%s" given', is_object($transactionsTransactionItem) ? get_class($transactionsTransactionItem) : gettype($transactionsTransactionItem)), __LINE__);
            }
        }
        $this->transaction = $transaction;
        return $this;
    }
    /**
     * Add item to transaction value
     * @throws \InvalidArgumentException
     * @param \StructType\TransactionHistoryReportImpl $item
     * @return \StructType\Transactions
     */
    public function addToTransaction(\StructType\TransactionHistoryReportImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TransactionHistoryReportImpl) {
            throw new \InvalidArgumentException(sprintf('The transaction property can only contain items of \StructType\TransactionHistoryReportImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->transaction[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transactions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
