<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telephonyPlanImpl StructType
 * @subpackage Structs
 */
class TelephonyPlanImpl extends TelephonyPlanBaseImpl
{
    /**
     * The submarketId
     * @var string
     */
    public $submarketId;
    /**
     * The servicePlanId
     * @var string
     */
    public $servicePlanId;
    /**
     * The servicePlanOptions
     * @var \StructType\ServicePlanOptions
     */
    public $servicePlanOptions;
    /**
     * The rudicsGroup
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rudicsGroup;
    /**
     * Constructor method for telephonyPlanImpl
     * @uses TelephonyPlanImpl::setSubmarketId()
     * @uses TelephonyPlanImpl::setServicePlanId()
     * @uses TelephonyPlanImpl::setServicePlanOptions()
     * @uses TelephonyPlanImpl::setRudicsGroup()
     * @param string $submarketId
     * @param string $servicePlanId
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     * @param string $rudicsGroup
     */
    public function __construct($submarketId = null, $servicePlanId = null, \StructType\ServicePlanOptions $servicePlanOptions = null, $rudicsGroup = null)
    {
        $this
            ->setSubmarketId($submarketId)
            ->setServicePlanId($servicePlanId)
            ->setServicePlanOptions($servicePlanOptions)
            ->setRudicsGroup($rudicsGroup);
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\TelephonyPlanImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Get servicePlanId value
     * @return string|null
     */
    public function getServicePlanId()
    {
        return $this->servicePlanId;
    }
    /**
     * Set servicePlanId value
     * @param string $servicePlanId
     * @return \StructType\TelephonyPlanImpl
     */
    public function setServicePlanId($servicePlanId = null)
    {
        // validation for constraint: string
        if (!is_null($servicePlanId) && !is_string($servicePlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($servicePlanId)), __LINE__);
        }
        $this->servicePlanId = $servicePlanId;
        return $this;
    }
    /**
     * Get servicePlanOptions value
     * @return \StructType\ServicePlanOptions|null
     */
    public function getServicePlanOptions()
    {
        return $this->servicePlanOptions;
    }
    /**
     * Set servicePlanOptions value
     * @param \StructType\ServicePlanOptions $servicePlanOptions
     * @return \StructType\TelephonyPlanImpl
     */
    public function setServicePlanOptions(\StructType\ServicePlanOptions $servicePlanOptions = null)
    {
        $this->servicePlanOptions = $servicePlanOptions;
        return $this;
    }
    /**
     * Get rudicsGroup value
     * @return string|null
     */
    public function getRudicsGroup()
    {
        return $this->rudicsGroup;
    }
    /**
     * Set rudicsGroup value
     * @param string $rudicsGroup
     * @return \StructType\TelephonyPlanImpl
     */
    public function setRudicsGroup($rudicsGroup = null)
    {
        // validation for constraint: string
        if (!is_null($rudicsGroup) && !is_string($rudicsGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rudicsGroup)), __LINE__);
        }
        $this->rudicsGroup = $rudicsGroup;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TelephonyPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
