<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subscribers StructType
 * @subpackage Structs
 */
class Subscribers extends AbstractStructBase
{
    /**
     * The subscriber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BurstSubscriberImpl[]
     */
    public $subscriber;
    /**
     * Constructor method for subscribers
     * @uses Subscribers::setSubscriber()
     * @param \StructType\BurstSubscriberImpl[] $subscriber
     */
    public function __construct(array $subscriber = array())
    {
        $this
            ->setSubscriber($subscriber);
    }
    /**
     * Get subscriber value
     * @return \StructType\BurstSubscriberImpl[]|null
     */
    public function getSubscriber()
    {
        return $this->subscriber;
    }
    /**
     * Set subscriber value
     * @throws \InvalidArgumentException
     * @param \StructType\BurstSubscriberImpl[] $subscriber
     * @return \StructType\Subscribers
     */
    public function setSubscriber(array $subscriber = array())
    {
        foreach ($subscriber as $subscribersSubscriberItem) {
            // validation for constraint: itemType
            if (!$subscribersSubscriberItem instanceof \StructType\BurstSubscriberImpl) {
                throw new \InvalidArgumentException(sprintf('The subscriber property can only contain items of \StructType\BurstSubscriberImpl, "%s" given', is_object($subscribersSubscriberItem) ? get_class($subscribersSubscriberItem) : gettype($subscribersSubscriberItem)), __LINE__);
            }
        }
        $this->subscriber = $subscriber;
        return $this;
    }
    /**
     * Add item to subscriber value
     * @throws \InvalidArgumentException
     * @param \StructType\BurstSubscriberImpl $item
     * @return \StructType\Subscribers
     */
    public function addToSubscriber(\StructType\BurstSubscriberImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BurstSubscriberImpl) {
            throw new \InvalidArgumentException(sprintf('The subscriber property can only contain items of \StructType\BurstSubscriberImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscriber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Subscribers
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
