<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subscriberOrgDetailReqImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:subscriberOrgDetailReqImpl
 * @subpackage Structs
 */
class SubscriberOrgDetailReqImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The subscriberOrgId
     * @var string
     */
    public $subscriberOrgId;
    /**
     * The deviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceType;
    /**
     * Constructor method for subscriberOrgDetailReqImpl
     * @uses SubscriberOrgDetailReqImpl::setSubscriberOrgId()
     * @uses SubscriberOrgDetailReqImpl::setDeviceType()
     * @param string $subscriberOrgId
     * @param string $deviceType
     */
    public function __construct($subscriberOrgId = null, $deviceType = null)
    {
        $this
            ->setSubscriberOrgId($subscriberOrgId)
            ->setDeviceType($deviceType);
    }
    /**
     * Get subscriberOrgId value
     * @return string|null
     */
    public function getSubscriberOrgId()
    {
        return $this->subscriberOrgId;
    }
    /**
     * Set subscriberOrgId value
     * @param string $subscriberOrgId
     * @return \StructType\SubscriberOrgDetailReqImpl
     */
    public function setSubscriberOrgId($subscriberOrgId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberOrgId) && !is_string($subscriberOrgId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberOrgId)), __LINE__);
        }
        $this->subscriberOrgId = $subscriberOrgId;
        return $this;
    }
    /**
     * Get deviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->deviceType;
    }
    /**
     * Set deviceType value
     * @uses \EnumType\PttTypeEnum::valueIsValid()
     * @uses \EnumType\PttTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceType
     * @return \StructType\SubscriberOrgDetailReqImpl
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PttTypeEnum::valueIsValid($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deviceType, implode(', ', \EnumType\PttTypeEnum::getValidValues())), __LINE__);
        }
        $this->deviceType = $deviceType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriberOrgDetailReqImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
