<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for subscriberAccountEntryImpl StructType
 * @subpackage Structs
 */
class SubscriberAccountEntryImpl extends AbstractStructBase
{
    /**
     * The subscriberAccountNumber
     * @var string
     */
    public $subscriberAccountNumber;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $requestType;
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The atsInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AtsInfoEntryImpl
     */
    public $atsInfo;
    /**
     * The subscriberOrganization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subscriberOrganization;
    /**
     * The deviceDetails
     * @var string
     */
    public $deviceDetails;
    /**
     * The accountStatus
     * @var string
     */
    public $accountStatus;
    /**
     * The statusDescription
     * @var string
     */
    public $statusDescription;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $createDate;
    /**
     * The modifyDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $modifyDate;
    /**
     * The closedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $closedDate;
    /**
     * Constructor method for subscriberAccountEntryImpl
     * @uses SubscriberAccountEntryImpl::setSubscriberAccountNumber()
     * @uses SubscriberAccountEntryImpl::setRequestType()
     * @uses SubscriberAccountEntryImpl::setServiceType()
     * @uses SubscriberAccountEntryImpl::setAtsInfo()
     * @uses SubscriberAccountEntryImpl::setSubscriberOrganization()
     * @uses SubscriberAccountEntryImpl::setDeviceDetails()
     * @uses SubscriberAccountEntryImpl::setAccountStatus()
     * @uses SubscriberAccountEntryImpl::setStatusDescription()
     * @uses SubscriberAccountEntryImpl::setCreateDate()
     * @uses SubscriberAccountEntryImpl::setModifyDate()
     * @uses SubscriberAccountEntryImpl::setClosedDate()
     * @param string $subscriberAccountNumber
     * @param string $requestType
     * @param string $serviceType
     * @param \StructType\AtsInfoEntryImpl $atsInfo
     * @param string $subscriberOrganization
     * @param string $deviceDetails
     * @param string $accountStatus
     * @param string $statusDescription
     * @param string $createDate
     * @param string $modifyDate
     * @param string $closedDate
     */
    public function __construct($subscriberAccountNumber = null, $requestType = null, $serviceType = null, \StructType\AtsInfoEntryImpl $atsInfo = null, $subscriberOrganization = null, $deviceDetails = null, $accountStatus = null, $statusDescription = null, $createDate = null, $modifyDate = null, $closedDate = null)
    {
        $this
            ->setSubscriberAccountNumber($subscriberAccountNumber)
            ->setRequestType($requestType)
            ->setServiceType($serviceType)
            ->setAtsInfo($atsInfo)
            ->setSubscriberOrganization($subscriberOrganization)
            ->setDeviceDetails($deviceDetails)
            ->setAccountStatus($accountStatus)
            ->setStatusDescription($statusDescription)
            ->setCreateDate($createDate)
            ->setModifyDate($modifyDate)
            ->setClosedDate($closedDate);
    }
    /**
     * Get subscriberAccountNumber value
     * @return string|null
     */
    public function getSubscriberAccountNumber()
    {
        return $this->subscriberAccountNumber;
    }
    /**
     * Set subscriberAccountNumber value
     * @param string $subscriberAccountNumber
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setSubscriberAccountNumber($subscriberAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberAccountNumber) && !is_string($subscriberAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberAccountNumber)), __LINE__);
        }
        $this->subscriberAccountNumber = $subscriberAccountNumber;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @param string $requestType
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get atsInfo value
     * @return \StructType\AtsInfoEntryImpl|null
     */
    public function getAtsInfo()
    {
        return $this->atsInfo;
    }
    /**
     * Set atsInfo value
     * @param \StructType\AtsInfoEntryImpl $atsInfo
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setAtsInfo(\StructType\AtsInfoEntryImpl $atsInfo = null)
    {
        $this->atsInfo = $atsInfo;
        return $this;
    }
    /**
     * Get subscriberOrganization value
     * @return string|null
     */
    public function getSubscriberOrganization()
    {
        return $this->subscriberOrganization;
    }
    /**
     * Set subscriberOrganization value
     * @param string $subscriberOrganization
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setSubscriberOrganization($subscriberOrganization = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberOrganization) && !is_string($subscriberOrganization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberOrganization)), __LINE__);
        }
        $this->subscriberOrganization = $subscriberOrganization;
        return $this;
    }
    /**
     * Get deviceDetails value
     * @return string|null
     */
    public function getDeviceDetails()
    {
        return $this->deviceDetails;
    }
    /**
     * Set deviceDetails value
     * @param string $deviceDetails
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setDeviceDetails($deviceDetails = null)
    {
        // validation for constraint: string
        if (!is_null($deviceDetails) && !is_string($deviceDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deviceDetails)), __LINE__);
        }
        $this->deviceDetails = $deviceDetails;
        return $this;
    }
    /**
     * Get accountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->accountStatus;
    }
    /**
     * Set accountStatus value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountStatus
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accountStatus, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->accountStatus = $accountStatus;
        return $this;
    }
    /**
     * Get statusDescription value
     * @return string|null
     */
    public function getStatusDescription()
    {
        return $this->statusDescription;
    }
    /**
     * Set statusDescription value
     * @param string $statusDescription
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setStatusDescription($statusDescription = null)
    {
        // validation for constraint: string
        if (!is_null($statusDescription) && !is_string($statusDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDescription)), __LINE__);
        }
        $this->statusDescription = $statusDescription;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get modifyDate value
     * @return string|null
     */
    public function getModifyDate()
    {
        return $this->modifyDate;
    }
    /**
     * Set modifyDate value
     * @param string $modifyDate
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setModifyDate($modifyDate = null)
    {
        // validation for constraint: string
        if (!is_null($modifyDate) && !is_string($modifyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifyDate)), __LINE__);
        }
        $this->modifyDate = $modifyDate;
        return $this;
    }
    /**
     * Get closedDate value
     * @return string|null
     */
    public function getClosedDate()
    {
        return $this->closedDate;
    }
    /**
     * Set closedDate value
     * @param string $closedDate
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public function setClosedDate($closedDate = null)
    {
        // validation for constraint: string
        if (!is_null($closedDate) && !is_string($closedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closedDate)), __LINE__);
        }
        $this->closedDate = $closedDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriberAccountEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
