<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for submarkets StructType
 * @subpackage Structs
 */
class Submarkets extends AbstractStructBase
{
    /**
     * The submarket
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubmarketPrepaidPlansImpl[]
     */
    public $submarket;
    /**
     * Constructor method for submarkets
     * @uses Submarkets::setSubmarket()
     * @param \StructType\SubmarketPrepaidPlansImpl[] $submarket
     */
    public function __construct(array $submarket = array())
    {
        $this
            ->setSubmarket($submarket);
    }
    /**
     * Get submarket value
     * @return \StructType\SubmarketPrepaidPlansImpl[]|null
     */
    public function getSubmarket()
    {
        return $this->submarket;
    }
    /**
     * Set submarket value
     * @throws \InvalidArgumentException
     * @param \StructType\SubmarketPrepaidPlansImpl[] $submarket
     * @return \StructType\Submarkets
     */
    public function setSubmarket(array $submarket = array())
    {
        foreach ($submarket as $submarketsSubmarketItem) {
            // validation for constraint: itemType
            if (!$submarketsSubmarketItem instanceof \StructType\SubmarketPrepaidPlansImpl) {
                throw new \InvalidArgumentException(sprintf('The submarket property can only contain items of \StructType\SubmarketPrepaidPlansImpl, "%s" given', is_object($submarketsSubmarketItem) ? get_class($submarketsSubmarketItem) : gettype($submarketsSubmarketItem)), __LINE__);
            }
        }
        $this->submarket = $submarket;
        return $this;
    }
    /**
     * Add item to submarket value
     * @throws \InvalidArgumentException
     * @param \StructType\SubmarketPrepaidPlansImpl $item
     * @return \StructType\Submarkets
     */
    public function addToSubmarket(\StructType\SubmarketPrepaidPlansImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubmarketPrepaidPlansImpl) {
            throw new \InvalidArgumentException(sprintf('The submarket property can only contain items of \StructType\SubmarketPrepaidPlansImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->submarket[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Submarkets
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
