<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for submarketImpl StructType
 * @subpackage Structs
 */
class SubmarketImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The submarketType
     * @var string
     */
    public $submarketType;
    /**
     * The servicePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ServicePlans
     */
    public $servicePlans;
    /**
     * Constructor method for submarketImpl
     * @uses SubmarketImpl::setId()
     * @uses SubmarketImpl::setName()
     * @uses SubmarketImpl::setCode()
     * @uses SubmarketImpl::setSubmarketType()
     * @uses SubmarketImpl::setServicePlans()
     * @param string $id
     * @param string $name
     * @param string $code
     * @param string $submarketType
     * @param \StructType\ServicePlans $servicePlans
     */
    public function __construct($id = null, $name = null, $code = null, $submarketType = null, \StructType\ServicePlans $servicePlans = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setCode($code)
            ->setSubmarketType($submarketType)
            ->setServicePlans($servicePlans);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SubmarketImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SubmarketImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SubmarketImpl
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get submarketType value
     * @return string|null
     */
    public function getSubmarketType()
    {
        return $this->submarketType;
    }
    /**
     * Set submarketType value
     * @uses \EnumType\SubmarketTypeEnum::valueIsValid()
     * @uses \EnumType\SubmarketTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $submarketType
     * @return \StructType\SubmarketImpl
     */
    public function setSubmarketType($submarketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SubmarketTypeEnum::valueIsValid($submarketType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $submarketType, implode(', ', \EnumType\SubmarketTypeEnum::getValidValues())), __LINE__);
        }
        $this->submarketType = $submarketType;
        return $this;
    }
    /**
     * Get servicePlans value
     * @return \StructType\ServicePlans|null
     */
    public function getServicePlans()
    {
        return $this->servicePlans;
    }
    /**
     * Set servicePlans value
     * @param \StructType\ServicePlans $servicePlans
     * @return \StructType\SubmarketImpl
     */
    public function setServicePlans(\StructType\ServicePlans $servicePlans = null)
    {
        $this->servicePlans = $servicePlans;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmarketImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
