<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for spServiceConfigurationInfoImpl StructType
 * @subpackage Structs
 */
class SpServiceConfigurationInfoImpl extends AbstractStructBase
{
    /**
     * The serviceType
     * @var string
     */
    public $serviceType;
    /**
     * The supported
     * @var bool
     */
    public $supported;
    /**
     * The demoOnly
     * @var bool
     */
    public $demoOnly;
    /**
     * The allowAutoRecharge
     * @var bool
     */
    public $allowAutoRecharge;
    /**
     * The demoAndTrialCounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DemoAndTrialCounts
     */
    public $demoAndTrialCounts;
    /**
     * Constructor method for spServiceConfigurationInfoImpl
     * @uses SpServiceConfigurationInfoImpl::setServiceType()
     * @uses SpServiceConfigurationInfoImpl::setSupported()
     * @uses SpServiceConfigurationInfoImpl::setDemoOnly()
     * @uses SpServiceConfigurationInfoImpl::setAllowAutoRecharge()
     * @uses SpServiceConfigurationInfoImpl::setDemoAndTrialCounts()
     * @param string $serviceType
     * @param bool $supported
     * @param bool $demoOnly
     * @param bool $allowAutoRecharge
     * @param \StructType\DemoAndTrialCounts $demoAndTrialCounts
     */
    public function __construct($serviceType = null, $supported = null, $demoOnly = null, $allowAutoRecharge = null, \StructType\DemoAndTrialCounts $demoAndTrialCounts = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setSupported($supported)
            ->setDemoOnly($demoOnly)
            ->setAllowAutoRecharge($allowAutoRecharge)
            ->setDemoAndTrialCounts($demoAndTrialCounts);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceProviderProfileConfigTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceProviderProfileConfigTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get supported value
     * @return bool|null
     */
    public function getSupported()
    {
        return $this->supported;
    }
    /**
     * Set supported value
     * @param bool $supported
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public function setSupported($supported = null)
    {
        $this->supported = $supported;
        return $this;
    }
    /**
     * Get demoOnly value
     * @return bool|null
     */
    public function getDemoOnly()
    {
        return $this->demoOnly;
    }
    /**
     * Set demoOnly value
     * @param bool $demoOnly
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public function setDemoOnly($demoOnly = null)
    {
        $this->demoOnly = $demoOnly;
        return $this;
    }
    /**
     * Get allowAutoRecharge value
     * @return bool|null
     */
    public function getAllowAutoRecharge()
    {
        return $this->allowAutoRecharge;
    }
    /**
     * Set allowAutoRecharge value
     * @param bool $allowAutoRecharge
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public function setAllowAutoRecharge($allowAutoRecharge = null)
    {
        $this->allowAutoRecharge = $allowAutoRecharge;
        return $this;
    }
    /**
     * Get demoAndTrialCounts value
     * @return \StructType\DemoAndTrialCounts|null
     */
    public function getDemoAndTrialCounts()
    {
        return $this->demoAndTrialCounts;
    }
    /**
     * Set demoAndTrialCounts value
     * @param \StructType\DemoAndTrialCounts $demoAndTrialCounts
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public function setDemoAndTrialCounts(\StructType\DemoAndTrialCounts $demoAndTrialCounts = null)
    {
        $this->demoAndTrialCounts = $demoAndTrialCounts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SpServiceConfigurationInfoImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
