<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simplifiedModelImpl StructType
 * @subpackage Structs
 */
class SimplifiedModelImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The vertical
     * @var string
     */
    public $vertical;
    /**
     * The manufacturer
     * @var string
     */
    public $manufacturer;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The modelNumber
     * @var string
     */
    public $modelNumber;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The certifiedFlag
     * @var string
     */
    public $certifiedFlag;
    /**
     * The seClassMark
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $seClassMark;
    /**
     * The maxB1Spd
     * @var int
     */
    public $maxB1Spd;
    /**
     * The maxNextSpd
     * @var int
     */
    public $maxNextSpd;
    /**
     * The c8ModCod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $c8ModCod;
    /**
     * Constructor method for simplifiedModelImpl
     * @uses SimplifiedModelImpl::setId()
     * @uses SimplifiedModelImpl::setVertical()
     * @uses SimplifiedModelImpl::setManufacturer()
     * @uses SimplifiedModelImpl::setName()
     * @uses SimplifiedModelImpl::setModelNumber()
     * @uses SimplifiedModelImpl::setStatus()
     * @uses SimplifiedModelImpl::setCertifiedFlag()
     * @uses SimplifiedModelImpl::setSeClassMark()
     * @uses SimplifiedModelImpl::setMaxB1Spd()
     * @uses SimplifiedModelImpl::setMaxNextSpd()
     * @uses SimplifiedModelImpl::setC8ModCod()
     * @param string $id
     * @param string $vertical
     * @param string $manufacturer
     * @param string $name
     * @param string $modelNumber
     * @param string $status
     * @param string $certifiedFlag
     * @param string $seClassMark
     * @param int $maxB1Spd
     * @param int $maxNextSpd
     * @param string $c8ModCod
     */
    public function __construct($id = null, $vertical = null, $manufacturer = null, $name = null, $modelNumber = null, $status = null, $certifiedFlag = null, $seClassMark = null, $maxB1Spd = null, $maxNextSpd = null, $c8ModCod = null)
    {
        $this
            ->setId($id)
            ->setVertical($vertical)
            ->setManufacturer($manufacturer)
            ->setName($name)
            ->setModelNumber($modelNumber)
            ->setStatus($status)
            ->setCertifiedFlag($certifiedFlag)
            ->setSeClassMark($seClassMark)
            ->setMaxB1Spd($maxB1Spd)
            ->setMaxNextSpd($maxNextSpd)
            ->setC8ModCod($c8ModCod);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SimplifiedModelImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get vertical value
     * @return string|null
     */
    public function getVertical()
    {
        return $this->vertical;
    }
    /**
     * Set vertical value
     * @param string $vertical
     * @return \StructType\SimplifiedModelImpl
     */
    public function setVertical($vertical = null)
    {
        // validation for constraint: string
        if (!is_null($vertical) && !is_string($vertical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vertical)), __LINE__);
        }
        $this->vertical = $vertical;
        return $this;
    }
    /**
     * Get manufacturer value
     * @return string|null
     */
    public function getManufacturer()
    {
        return $this->manufacturer;
    }
    /**
     * Set manufacturer value
     * @param string $manufacturer
     * @return \StructType\SimplifiedModelImpl
     */
    public function setManufacturer($manufacturer = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturer) && !is_string($manufacturer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturer)), __LINE__);
        }
        $this->manufacturer = $manufacturer;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SimplifiedModelImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get modelNumber value
     * @return string|null
     */
    public function getModelNumber()
    {
        return $this->modelNumber;
    }
    /**
     * Set modelNumber value
     * @param string $modelNumber
     * @return \StructType\SimplifiedModelImpl
     */
    public function setModelNumber($modelNumber = null)
    {
        // validation for constraint: string
        if (!is_null($modelNumber) && !is_string($modelNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelNumber)), __LINE__);
        }
        $this->modelNumber = $modelNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ObjectStatusEnum::valueIsValid()
     * @uses \EnumType\ObjectStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SimplifiedModelImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObjectStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ObjectStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get certifiedFlag value
     * @return string|null
     */
    public function getCertifiedFlag()
    {
        return $this->certifiedFlag;
    }
    /**
     * Set certifiedFlag value
     * @param string $certifiedFlag
     * @return \StructType\SimplifiedModelImpl
     */
    public function setCertifiedFlag($certifiedFlag = null)
    {
        // validation for constraint: string
        if (!is_null($certifiedFlag) && !is_string($certifiedFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certifiedFlag)), __LINE__);
        }
        $this->certifiedFlag = $certifiedFlag;
        return $this;
    }
    /**
     * Get seClassMark value
     * @return string|null
     */
    public function getSeClassMark()
    {
        return $this->seClassMark;
    }
    /**
     * Set seClassMark value
     * @param string $seClassMark
     * @return \StructType\SimplifiedModelImpl
     */
    public function setSeClassMark($seClassMark = null)
    {
        // validation for constraint: string
        if (!is_null($seClassMark) && !is_string($seClassMark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seClassMark)), __LINE__);
        }
        $this->seClassMark = $seClassMark;
        return $this;
    }
    /**
     * Get maxB1Spd value
     * @return int|null
     */
    public function getMaxB1Spd()
    {
        return $this->maxB1Spd;
    }
    /**
     * Set maxB1Spd value
     * @param int $maxB1Spd
     * @return \StructType\SimplifiedModelImpl
     */
    public function setMaxB1Spd($maxB1Spd = null)
    {
        // validation for constraint: int
        if (!is_null($maxB1Spd) && !is_numeric($maxB1Spd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxB1Spd)), __LINE__);
        }
        $this->maxB1Spd = $maxB1Spd;
        return $this;
    }
    /**
     * Get maxNextSpd value
     * @return int|null
     */
    public function getMaxNextSpd()
    {
        return $this->maxNextSpd;
    }
    /**
     * Set maxNextSpd value
     * @param int $maxNextSpd
     * @return \StructType\SimplifiedModelImpl
     */
    public function setMaxNextSpd($maxNextSpd = null)
    {
        // validation for constraint: int
        if (!is_null($maxNextSpd) && !is_numeric($maxNextSpd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNextSpd)), __LINE__);
        }
        $this->maxNextSpd = $maxNextSpd;
        return $this;
    }
    /**
     * Get c8ModCod value
     * @return string|null
     */
    public function getC8ModCod()
    {
        return $this->c8ModCod;
    }
    /**
     * Set c8ModCod value
     * @param string $c8ModCod
     * @return \StructType\SimplifiedModelImpl
     */
    public function setC8ModCod($c8ModCod = null)
    {
        // validation for constraint: string
        if (!is_null($c8ModCod) && !is_string($c8ModCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($c8ModCod)), __LINE__);
        }
        $this->c8ModCod = $c8ModCod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SimplifiedModelImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
