<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendMessageToDeviceRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sendMessageToDeviceRequestImpl
 * @subpackage Structs
 */
class SendMessageToDeviceRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * The contentType
     * @var string
     */
    public $contentType;
    /**
     * Constructor method for sendMessageToDeviceRequestImpl
     * @uses SendMessageToDeviceRequestImpl::setSearchType()
     * @uses SendMessageToDeviceRequestImpl::setValue()
     * @uses SendMessageToDeviceRequestImpl::setMessage()
     * @uses SendMessageToDeviceRequestImpl::setContentType()
     * @param string $searchType
     * @param string $value
     * @param string $message
     * @param string $contentType
     */
    public function __construct($searchType = null, $value = null, $message = null, $contentType = null)
    {
        $this
            ->setSearchType($searchType)
            ->setValue($value)
            ->setMessage($message)
            ->setContentType($contentType);
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SbdSearchTypeEnum::valueIsValid()
     * @uses \EnumType\SbdSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SendMessageToDeviceRequestImpl
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdSearchTypeEnum::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\SbdSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\SendMessageToDeviceRequestImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SendMessageToDeviceRequestImpl
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get contentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->contentType;
    }
    /**
     * Set contentType value
     * @uses \EnumType\MessageContentTypeEnum::valueIsValid()
     * @uses \EnumType\MessageContentTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $contentType
     * @return \StructType\SendMessageToDeviceRequestImpl
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageContentTypeEnum::valueIsValid($contentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $contentType, implode(', ', \EnumType\MessageContentTypeEnum::getValidValues())), __LINE__);
        }
        $this->contentType = $contentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMessageToDeviceRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
