<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendMessageResultImpl StructType
 * @subpackage Structs
 */
class SendMessageResultImpl extends AbstractStructBase
{
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The messageSize
     * @var int
     */
    public $messageSize;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * Constructor method for sendMessageResultImpl
     * @uses SendMessageResultImpl::setStatus()
     * @uses SendMessageResultImpl::setImei()
     * @uses SendMessageResultImpl::setMessageSize()
     * @uses SendMessageResultImpl::setMessage()
     * @param string $status
     * @param string $imei
     * @param int $messageSize
     * @param string $message
     */
    public function __construct($status = null, $imei = null, $messageSize = null, $message = null)
    {
        $this
            ->setStatus($status)
            ->setImei($imei)
            ->setMessageSize($messageSize)
            ->setMessage($message);
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\SbdSendMessageStatusTypeEnum::valueIsValid()
     * @uses \EnumType\SbdSendMessageStatusTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\SendMessageResultImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdSendMessageStatusTypeEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\SbdSendMessageStatusTypeEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\SendMessageResultImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get messageSize value
     * @return int|null
     */
    public function getMessageSize()
    {
        return $this->messageSize;
    }
    /**
     * Set messageSize value
     * @param int $messageSize
     * @return \StructType\SendMessageResultImpl
     */
    public function setMessageSize($messageSize = null)
    {
        // validation for constraint: int
        if (!is_null($messageSize) && !is_numeric($messageSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageSize)), __LINE__);
        }
        $this->messageSize = $messageSize;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\SendMessageResultImpl
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SendMessageResultImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
