<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdmoActivityImpl StructType
 * @subpackage Structs
 */
class SbdmoActivityImpl extends SbdActivityImpl
{
    /**
     * The timeSent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timeSent;
    /**
     * The latitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $longitude;
    /**
     * The cep
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cep;
    /**
     * The momsn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $momsn;
    /**
     * The deliveryMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryMethod;
    /**
     * The callStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callStatus;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * Constructor method for sbdmoActivityImpl
     * @uses SbdmoActivityImpl::setTimeSent()
     * @uses SbdmoActivityImpl::setLatitude()
     * @uses SbdmoActivityImpl::setLongitude()
     * @uses SbdmoActivityImpl::setCep()
     * @uses SbdmoActivityImpl::setMomsn()
     * @uses SbdmoActivityImpl::setDeliveryMethod()
     * @uses SbdmoActivityImpl::setCallStatus()
     * @uses SbdmoActivityImpl::setDestination()
     * @param string $timeSent
     * @param float $latitude
     * @param float $longitude
     * @param int $cep
     * @param string $momsn
     * @param string $deliveryMethod
     * @param string $callStatus
     * @param string $destination
     */
    public function __construct($timeSent = null, $latitude = null, $longitude = null, $cep = null, $momsn = null, $deliveryMethod = null, $callStatus = null, $destination = null)
    {
        $this
            ->setTimeSent($timeSent)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setCep($cep)
            ->setMomsn($momsn)
            ->setDeliveryMethod($deliveryMethod)
            ->setCallStatus($callStatus)
            ->setDestination($destination);
    }
    /**
     * Get timeSent value
     * @return string|null
     */
    public function getTimeSent()
    {
        return $this->timeSent;
    }
    /**
     * Set timeSent value
     * @param string $timeSent
     * @return \StructType\SbdmoActivityImpl
     */
    public function setTimeSent($timeSent = null)
    {
        // validation for constraint: string
        if (!is_null($timeSent) && !is_string($timeSent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeSent)), __LINE__);
        }
        $this->timeSent = $timeSent;
        return $this;
    }
    /**
     * Get latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\SbdmoActivityImpl
     */
    public function setLatitude($latitude = null)
    {
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\SbdmoActivityImpl
     */
    public function setLongitude($longitude = null)
    {
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get cep value
     * @return int|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param int $cep
     * @return \StructType\SbdmoActivityImpl
     */
    public function setCep($cep = null)
    {
        // validation for constraint: int
        if (!is_null($cep) && !is_numeric($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
    /**
     * Get momsn value
     * @return string|null
     */
    public function getMomsn()
    {
        return $this->momsn;
    }
    /**
     * Set momsn value
     * @param string $momsn
     * @return \StructType\SbdmoActivityImpl
     */
    public function setMomsn($momsn = null)
    {
        // validation for constraint: string
        if (!is_null($momsn) && !is_string($momsn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($momsn)), __LINE__);
        }
        $this->momsn = $momsn;
        return $this;
    }
    /**
     * Get deliveryMethod value
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->deliveryMethod;
    }
    /**
     * Set deliveryMethod value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethod
     * @return \StructType\SbdmoActivityImpl
     */
    public function setDeliveryMethod($deliveryMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethod, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethod = $deliveryMethod;
        return $this;
    }
    /**
     * Get callStatus value
     * @return string|null
     */
    public function getCallStatus()
    {
        return $this->callStatus;
    }
    /**
     * Set callStatus value
     * @param string $callStatus
     * @return \StructType\SbdmoActivityImpl
     */
    public function setCallStatus($callStatus = null)
    {
        // validation for constraint: string
        if (!is_null($callStatus) && !is_string($callStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callStatus)), __LINE__);
        }
        $this->callStatus = $callStatus;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\SbdmoActivityImpl
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdmoActivityImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
