<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdSubscriberAccountImpl StructType
 * @subpackage Structs
 */
class SbdSubscriberAccountImpl extends AbsSubscriberAccountImpl
{
    /**
     * The plan
     * @var \StructType\SbdPlanImpl
     */
    public $plan;
    /**
     * The subscriberAccountMetadata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SbdSubscriberAccountMetadataImpl
     */
    public $subscriberAccountMetadata;
    /**
     * The imei
     * @var string
     */
    public $imei;
    /**
     * The bulkAction
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $bulkAction;
    /**
     * The sbdBulkDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SbdBulkDetails
     */
    public $sbdBulkDetails;
    /**
     * The deliveryDetails
     * @var \StructType\DeliveryDetails
     */
    public $deliveryDetails;
    /**
     * The mtFilters
     * @var \StructType\MtFilters
     */
    public $mtFilters;
    /**
     * Constructor method for sbdSubscriberAccountImpl
     * @uses SbdSubscriberAccountImpl::setPlan()
     * @uses SbdSubscriberAccountImpl::setSubscriberAccountMetadata()
     * @uses SbdSubscriberAccountImpl::setImei()
     * @uses SbdSubscriberAccountImpl::setBulkAction()
     * @uses SbdSubscriberAccountImpl::setSbdBulkDetails()
     * @uses SbdSubscriberAccountImpl::setDeliveryDetails()
     * @uses SbdSubscriberAccountImpl::setMtFilters()
     * @param \StructType\SbdPlanImpl $plan
     * @param \StructType\SbdSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @param string $imei
     * @param bool $bulkAction
     * @param \StructType\SbdBulkDetails $sbdBulkDetails
     * @param \StructType\DeliveryDetails $deliveryDetails
     * @param \StructType\MtFilters $mtFilters
     */
    public function __construct(\StructType\SbdPlanImpl $plan = null, \StructType\SbdSubscriberAccountMetadataImpl $subscriberAccountMetadata = null, $imei = null, $bulkAction = false, \StructType\SbdBulkDetails $sbdBulkDetails = null, \StructType\DeliveryDetails $deliveryDetails = null, \StructType\MtFilters $mtFilters = null)
    {
        $this
            ->setPlan($plan)
            ->setSubscriberAccountMetadata($subscriberAccountMetadata)
            ->setImei($imei)
            ->setBulkAction($bulkAction)
            ->setSbdBulkDetails($sbdBulkDetails)
            ->setDeliveryDetails($deliveryDetails)
            ->setMtFilters($mtFilters);
    }
    /**
     * Get plan value
     * @return \StructType\SbdPlanImpl|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param \StructType\SbdPlanImpl $plan
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setPlan(\StructType\SbdPlanImpl $plan = null)
    {
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get subscriberAccountMetadata value
     * @return \StructType\SbdSubscriberAccountMetadataImpl|null
     */
    public function getSubscriberAccountMetadata()
    {
        return $this->subscriberAccountMetadata;
    }
    /**
     * Set subscriberAccountMetadata value
     * @param \StructType\SbdSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setSubscriberAccountMetadata(\StructType\SbdSubscriberAccountMetadataImpl $subscriberAccountMetadata = null)
    {
        $this->subscriberAccountMetadata = $subscriberAccountMetadata;
        return $this;
    }
    /**
     * Get imei value
     * @return string|null
     */
    public function getImei()
    {
        return $this->imei;
    }
    /**
     * Set imei value
     * @param string $imei
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setImei($imei = null)
    {
        // validation for constraint: string
        if (!is_null($imei) && !is_string($imei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($imei)), __LINE__);
        }
        $this->imei = $imei;
        return $this;
    }
    /**
     * Get bulkAction value
     * @return bool|null
     */
    public function getBulkAction()
    {
        return $this->bulkAction;
    }
    /**
     * Set bulkAction value
     * @param bool $bulkAction
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setBulkAction($bulkAction = false)
    {
        $this->bulkAction = $bulkAction;
        return $this;
    }
    /**
     * Get sbdBulkDetails value
     * @return \StructType\SbdBulkDetails|null
     */
    public function getSbdBulkDetails()
    {
        return $this->sbdBulkDetails;
    }
    /**
     * Set sbdBulkDetails value
     * @param \StructType\SbdBulkDetails $sbdBulkDetails
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setSbdBulkDetails(\StructType\SbdBulkDetails $sbdBulkDetails = null)
    {
        $this->sbdBulkDetails = $sbdBulkDetails;
        return $this;
    }
    /**
     * Get deliveryDetails value
     * @return \StructType\DeliveryDetails|null
     */
    public function getDeliveryDetails()
    {
        return $this->deliveryDetails;
    }
    /**
     * Set deliveryDetails value
     * @param \StructType\DeliveryDetails $deliveryDetails
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setDeliveryDetails(\StructType\DeliveryDetails $deliveryDetails = null)
    {
        $this->deliveryDetails = $deliveryDetails;
        return $this;
    }
    /**
     * Get mtFilters value
     * @return \StructType\MtFilters|null
     */
    public function getMtFilters()
    {
        return $this->mtFilters;
    }
    /**
     * Set mtFilters value
     * @param \StructType\MtFilters $mtFilters
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public function setMtFilters(\StructType\MtFilters $mtFilters = null)
    {
        $this->mtFilters = $mtFilters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdSubscriberAccountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
