<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdMOQueueReportRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sbdMOQueueReportRequestImpl
 * @subpackage Structs
 */
class SbdMOQueueReportRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The deliveryMethodType
     * @var string
     */
    public $deliveryMethodType;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The deliveryStatusType
     * @var string
     */
    public $deliveryStatusType;
    /**
     * Constructor method for sbdMOQueueReportRequestImpl
     * @uses SbdMOQueueReportRequestImpl::setDeliveryMethodType()
     * @uses SbdMOQueueReportRequestImpl::setAddress()
     * @uses SbdMOQueueReportRequestImpl::setDeliveryStatusType()
     * @param string $deliveryMethodType
     * @param string $address
     * @param string $deliveryStatusType
     */
    public function __construct($deliveryMethodType = null, $address = null, $deliveryStatusType = null)
    {
        $this
            ->setDeliveryMethodType($deliveryMethodType)
            ->setAddress($address)
            ->setDeliveryStatusType($deliveryStatusType);
    }
    /**
     * Get deliveryMethodType value
     * @return string|null
     */
    public function getDeliveryMethodType()
    {
        return $this->deliveryMethodType;
    }
    /**
     * Set deliveryMethodType value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethodType
     * @return \StructType\SbdMOQueueReportRequestImpl
     */
    public function setDeliveryMethodType($deliveryMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethodType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethodType, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethodType = $deliveryMethodType;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\SbdMOQueueReportRequestImpl
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get deliveryStatusType value
     * @return string|null
     */
    public function getDeliveryStatusType()
    {
        return $this->deliveryStatusType;
    }
    /**
     * Set deliveryStatusType value
     * @uses \EnumType\DeliveryStatusTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryStatusTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatusType
     * @return \StructType\SbdMOQueueReportRequestImpl
     */
    public function setDeliveryStatusType($deliveryStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryStatusTypeEnum::valueIsValid($deliveryStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryStatusType, implode(', ', \EnumType\DeliveryStatusTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryStatusType = $deliveryStatusType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdMOQueueReportRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
