<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdMOQueuePurgeRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sbdMOQueuePurgeRequestImpl
 * @subpackage Structs
 */
class SbdMOQueuePurgeRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The deliveryMethodType
     * @var string
     */
    public $deliveryMethodType;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * Constructor method for sbdMOQueuePurgeRequestImpl
     * @uses SbdMOQueuePurgeRequestImpl::setDeliveryMethodType()
     * @uses SbdMOQueuePurgeRequestImpl::setAddress()
     * @param string $deliveryMethodType
     * @param string $address
     */
    public function __construct($deliveryMethodType = null, $address = null)
    {
        $this
            ->setDeliveryMethodType($deliveryMethodType)
            ->setAddress($address);
    }
    /**
     * Get deliveryMethodType value
     * @return string|null
     */
    public function getDeliveryMethodType()
    {
        return $this->deliveryMethodType;
    }
    /**
     * Set deliveryMethodType value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethodType
     * @return \StructType\SbdMOQueuePurgeRequestImpl
     */
    public function setDeliveryMethodType($deliveryMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethodType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethodType, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethodType = $deliveryMethodType;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\SbdMOQueuePurgeRequestImpl
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdMOQueuePurgeRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
