<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sbdDeletePendingDownloadsRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:sbdDeletePendingDownloadsRequestImpl
 * @subpackage Structs
 */
class SbdDeletePendingDownloadsRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The searchType
     * @var string
     */
    public $searchType;
    /**
     * The value
     * @var string
     */
    public $value;
    /**
     * The messageIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MessageIds
     */
    public $messageIds;
    /**
     * The queuedMessage
     * @var bool
     */
    public $queuedMessage;
    /**
     * Constructor method for sbdDeletePendingDownloadsRequestImpl
     * @uses SbdDeletePendingDownloadsRequestImpl::setSearchType()
     * @uses SbdDeletePendingDownloadsRequestImpl::setValue()
     * @uses SbdDeletePendingDownloadsRequestImpl::setMessageIds()
     * @uses SbdDeletePendingDownloadsRequestImpl::setQueuedMessage()
     * @param string $searchType
     * @param string $value
     * @param \StructType\MessageIds $messageIds
     * @param bool $queuedMessage
     */
    public function __construct($searchType = null, $value = null, \StructType\MessageIds $messageIds = null, $queuedMessage = null)
    {
        $this
            ->setSearchType($searchType)
            ->setValue($value)
            ->setMessageIds($messageIds)
            ->setQueuedMessage($queuedMessage);
    }
    /**
     * Get searchType value
     * @return string|null
     */
    public function getSearchType()
    {
        return $this->searchType;
    }
    /**
     * Set searchType value
     * @uses \EnumType\SbdSearchTypeEnum::valueIsValid()
     * @uses \EnumType\SbdSearchTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $searchType
     * @return \StructType\SbdDeletePendingDownloadsRequestImpl
     */
    public function setSearchType($searchType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SbdSearchTypeEnum::valueIsValid($searchType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $searchType, implode(', ', \EnumType\SbdSearchTypeEnum::getValidValues())), __LINE__);
        }
        $this->searchType = $searchType;
        return $this;
    }
    /**
     * Get value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param string $value
     * @return \StructType\SbdDeletePendingDownloadsRequestImpl
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get messageIds value
     * @return \StructType\MessageIds|null
     */
    public function getMessageIds()
    {
        return $this->messageIds;
    }
    /**
     * Set messageIds value
     * @param \StructType\MessageIds $messageIds
     * @return \StructType\SbdDeletePendingDownloadsRequestImpl
     */
    public function setMessageIds(\StructType\MessageIds $messageIds = null)
    {
        $this->messageIds = $messageIds;
        return $this;
    }
    /**
     * Get queuedMessage value
     * @return bool|null
     */
    public function getQueuedMessage()
    {
        return $this->queuedMessage;
    }
    /**
     * Set queuedMessage value
     * @param bool $queuedMessage
     * @return \StructType\SbdDeletePendingDownloadsRequestImpl
     */
    public function setQueuedMessage($queuedMessage = null)
    {
        $this->queuedMessage = $queuedMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SbdDeletePendingDownloadsRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
