<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for roles StructType
 * @subpackage Structs
 */
class Roles extends AbstractStructBase
{
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $role;
    /**
     * Constructor method for roles
     * @uses Roles::setRole()
     * @param string[] $role
     */
    public function __construct(array $role = array())
    {
        $this
            ->setRole($role);
    }
    /**
     * Get role value
     * @return string[]|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\RoleTypeEnum::valueIsValid()
     * @uses \EnumType\RoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $role
     * @return \StructType\Roles
     */
    public function setRole(array $role = array())
    {
        $invalidValues = array();
        foreach ($role as $rolesRoleItem) {
            if (!\EnumType\RoleTypeEnum::valueIsValid($rolesRoleItem)) {
                $invalidValues[] = var_export($rolesRoleItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\RoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Add item to role value
     * @uses \EnumType\RoleTypeEnum::valueIsValid()
     * @uses \EnumType\RoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Roles
     */
    public function addToRole($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\RoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->role[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Roles
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
