<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resetUserPasswordRequestImpl StructType
 * @subpackage Structs
 */
class ResetUserPasswordRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The username
     * @var string
     */
    public $username;
    /**
     * The tokenTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tokenTimestamp;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for resetUserPasswordRequestImpl
     * @uses ResetUserPasswordRequestImpl::setUsername()
     * @uses ResetUserPasswordRequestImpl::setTokenTimestamp()
     * @uses ResetUserPasswordRequestImpl::setToken()
     * @param string $username
     * @param string $tokenTimestamp
     * @param string $token
     */
    public function __construct($username = null, $tokenTimestamp = null, $token = null)
    {
        $this
            ->setUsername($username)
            ->setTokenTimestamp($tokenTimestamp)
            ->setToken($token);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\ResetUserPasswordRequestImpl
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get tokenTimestamp value
     * @return string|null
     */
    public function getTokenTimestamp()
    {
        return $this->tokenTimestamp;
    }
    /**
     * Set tokenTimestamp value
     * @param string $tokenTimestamp
     * @return \StructType\ResetUserPasswordRequestImpl
     */
    public function setTokenTimestamp($tokenTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($tokenTimestamp) && !is_string($tokenTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tokenTimestamp)), __LINE__);
        }
        $this->tokenTimestamp = $tokenTimestamp;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\ResetUserPasswordRequestImpl
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetUserPasswordRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
