<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resetTelephonyVMPinRequestImpl StructType
 * @subpackage Structs
 */
class ResetTelephonyVMPinRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The accountNumber
     * @var string
     */
    public $accountNumber;
    /**
     * The msisdn
     * @var string
     */
    public $msisdn;
    /**
     * The newValue
     * Meta informations extracted from the WSDL
     * - default: 9999
     * @var int
     */
    public $newValue;
    /**
     * Constructor method for resetTelephonyVMPinRequestImpl
     * @uses ResetTelephonyVMPinRequestImpl::setAccountNumber()
     * @uses ResetTelephonyVMPinRequestImpl::setMsisdn()
     * @uses ResetTelephonyVMPinRequestImpl::setNewValue()
     * @param string $accountNumber
     * @param string $msisdn
     * @param int $newValue
     */
    public function __construct($accountNumber = null, $msisdn = null, $newValue = 9999)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setMsisdn($msisdn)
            ->setNewValue($newValue);
    }
    /**
     * Get accountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \StructType\ResetTelephonyVMPinRequestImpl
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get msisdn value
     * @return string|null
     */
    public function getMsisdn()
    {
        return $this->msisdn;
    }
    /**
     * Set msisdn value
     * @param string $msisdn
     * @return \StructType\ResetTelephonyVMPinRequestImpl
     */
    public function setMsisdn($msisdn = null)
    {
        // validation for constraint: string
        if (!is_null($msisdn) && !is_string($msisdn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msisdn)), __LINE__);
        }
        $this->msisdn = $msisdn;
        return $this;
    }
    /**
     * Get newValue value
     * @return int|null
     */
    public function getNewValue()
    {
        return $this->newValue;
    }
    /**
     * Set newValue value
     * @param int $newValue
     * @return \StructType\ResetTelephonyVMPinRequestImpl
     */
    public function setNewValue($newValue = 9999)
    {
        // validation for constraint: int
        if (!is_null($newValue) && !is_numeric($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($newValue)), __LINE__);
        }
        $this->newValue = $newValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResetTelephonyVMPinRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
