<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pttTalkgroupDetailImpl StructType
 * @subpackage Structs
 */
class PttTalkgroupDetailImpl extends AbstractStructBase
{
    /**
     * The contractId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contractId;
    /**
     * The controllerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $controllerId;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The activationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $activationDate;
    /**
     * Constructor method for pttTalkgroupDetailImpl
     * @uses PttTalkgroupDetailImpl::setContractId()
     * @uses PttTalkgroupDetailImpl::setControllerId()
     * @uses PttTalkgroupDetailImpl::setName()
     * @uses PttTalkgroupDetailImpl::setStatus()
     * @uses PttTalkgroupDetailImpl::setActivationDate()
     * @param string $contractId
     * @param string $controllerId
     * @param string $name
     * @param string $status
     * @param string $activationDate
     */
    public function __construct($contractId = null, $controllerId = null, $name = null, $status = null, $activationDate = null)
    {
        $this
            ->setContractId($contractId)
            ->setControllerId($controllerId)
            ->setName($name)
            ->setStatus($status)
            ->setActivationDate($activationDate);
    }
    /**
     * Get contractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param string $contractId
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get controllerId value
     * @return string|null
     */
    public function getControllerId()
    {
        return $this->controllerId;
    }
    /**
     * Set controllerId value
     * @param string $controllerId
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public function setControllerId($controllerId = null)
    {
        // validation for constraint: string
        if (!is_null($controllerId) && !is_string($controllerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controllerId)), __LINE__);
        }
        $this->controllerId = $controllerId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\AccountStatusEnum::valueIsValid()
     * @uses \EnumType\AccountStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\AccountStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get activationDate value
     * @return string|null
     */
    public function getActivationDate()
    {
        return $this->activationDate;
    }
    /**
     * Set activationDate value
     * @param string $activationDate
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public function setActivationDate($activationDate = null)
    {
        // validation for constraint: string
        if (!is_null($activationDate) && !is_string($activationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activationDate)), __LINE__);
        }
        $this->activationDate = $activationDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PttTalkgroupDetailImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
