<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for provisioningFailureEntryImpl StructType
 * @subpackage Structs
 */
class ProvisioningFailureEntryImpl extends AbstractStructBase
{
    /**
     * The subscriberAccountNumber
     * @var string
     */
    public $subscriberAccountNumber;
    /**
     * The failureStatus
     * @var string
     */
    public $failureStatus;
    /**
     * The failureMsg
     * @var string
     */
    public $failureMsg;
    /**
     * The failureDate
     * @var string
     */
    public $failureDate;
    /**
     * Constructor method for provisioningFailureEntryImpl
     * @uses ProvisioningFailureEntryImpl::setSubscriberAccountNumber()
     * @uses ProvisioningFailureEntryImpl::setFailureStatus()
     * @uses ProvisioningFailureEntryImpl::setFailureMsg()
     * @uses ProvisioningFailureEntryImpl::setFailureDate()
     * @param string $subscriberAccountNumber
     * @param string $failureStatus
     * @param string $failureMsg
     * @param string $failureDate
     */
    public function __construct($subscriberAccountNumber = null, $failureStatus = null, $failureMsg = null, $failureDate = null)
    {
        $this
            ->setSubscriberAccountNumber($subscriberAccountNumber)
            ->setFailureStatus($failureStatus)
            ->setFailureMsg($failureMsg)
            ->setFailureDate($failureDate);
    }
    /**
     * Get subscriberAccountNumber value
     * @return string|null
     */
    public function getSubscriberAccountNumber()
    {
        return $this->subscriberAccountNumber;
    }
    /**
     * Set subscriberAccountNumber value
     * @param string $subscriberAccountNumber
     * @return \StructType\ProvisioningFailureEntryImpl
     */
    public function setSubscriberAccountNumber($subscriberAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriberAccountNumber) && !is_string($subscriberAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberAccountNumber)), __LINE__);
        }
        $this->subscriberAccountNumber = $subscriberAccountNumber;
        return $this;
    }
    /**
     * Get failureStatus value
     * @return string|null
     */
    public function getFailureStatus()
    {
        return $this->failureStatus;
    }
    /**
     * Set failureStatus value
     * @uses \EnumType\ServiceOrderStatusEnum::valueIsValid()
     * @uses \EnumType\ServiceOrderStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failureStatus
     * @return \StructType\ProvisioningFailureEntryImpl
     */
    public function setFailureStatus($failureStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceOrderStatusEnum::valueIsValid($failureStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failureStatus, implode(', ', \EnumType\ServiceOrderStatusEnum::getValidValues())), __LINE__);
        }
        $this->failureStatus = $failureStatus;
        return $this;
    }
    /**
     * Get failureMsg value
     * @return string|null
     */
    public function getFailureMsg()
    {
        return $this->failureMsg;
    }
    /**
     * Set failureMsg value
     * @param string $failureMsg
     * @return \StructType\ProvisioningFailureEntryImpl
     */
    public function setFailureMsg($failureMsg = null)
    {
        // validation for constraint: string
        if (!is_null($failureMsg) && !is_string($failureMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureMsg)), __LINE__);
        }
        $this->failureMsg = $failureMsg;
        return $this;
    }
    /**
     * Get failureDate value
     * @return string|null
     */
    public function getFailureDate()
    {
        return $this->failureDate;
    }
    /**
     * Set failureDate value
     * @param string $failureDate
     * @return \StructType\ProvisioningFailureEntryImpl
     */
    public function setFailureDate($failureDate = null)
    {
        // validation for constraint: string
        if (!is_null($failureDate) && !is_string($failureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($failureDate)), __LINE__);
        }
        $this->failureDate = $failureDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProvisioningFailureEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
