<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prepaidVoucherImpl StructType
 * @subpackage Structs
 */
class PrepaidVoucherImpl extends AbstractStructBase
{
    /**
     * The voucherDenominationId
     * @var string
     */
    public $voucherDenominationId;
    /**
     * The voucherActionType
     * @var string
     */
    public $voucherActionType;
    /**
     * The voucherQuantity
     * @var string
     */
    public $voucherQuantity;
    /**
     * The thirtyDayExtQty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $thirtyDayExtQty;
    /**
     * Constructor method for prepaidVoucherImpl
     * @uses PrepaidVoucherImpl::setVoucherDenominationId()
     * @uses PrepaidVoucherImpl::setVoucherActionType()
     * @uses PrepaidVoucherImpl::setVoucherQuantity()
     * @uses PrepaidVoucherImpl::setThirtyDayExtQty()
     * @param string $voucherDenominationId
     * @param string $voucherActionType
     * @param string $voucherQuantity
     * @param string $thirtyDayExtQty
     */
    public function __construct($voucherDenominationId = null, $voucherActionType = null, $voucherQuantity = null, $thirtyDayExtQty = null)
    {
        $this
            ->setVoucherDenominationId($voucherDenominationId)
            ->setVoucherActionType($voucherActionType)
            ->setVoucherQuantity($voucherQuantity)
            ->setThirtyDayExtQty($thirtyDayExtQty);
    }
    /**
     * Get voucherDenominationId value
     * @return string|null
     */
    public function getVoucherDenominationId()
    {
        return $this->voucherDenominationId;
    }
    /**
     * Set voucherDenominationId value
     * @param string $voucherDenominationId
     * @return \StructType\PrepaidVoucherImpl
     */
    public function setVoucherDenominationId($voucherDenominationId = null)
    {
        // validation for constraint: string
        if (!is_null($voucherDenominationId) && !is_string($voucherDenominationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voucherDenominationId)), __LINE__);
        }
        $this->voucherDenominationId = $voucherDenominationId;
        return $this;
    }
    /**
     * Get voucherActionType value
     * @return string|null
     */
    public function getVoucherActionType()
    {
        return $this->voucherActionType;
    }
    /**
     * Set voucherActionType value
     * @uses \EnumType\VoucherActionTypeEnum::valueIsValid()
     * @uses \EnumType\VoucherActionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $voucherActionType
     * @return \StructType\PrepaidVoucherImpl
     */
    public function setVoucherActionType($voucherActionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VoucherActionTypeEnum::valueIsValid($voucherActionType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $voucherActionType, implode(', ', \EnumType\VoucherActionTypeEnum::getValidValues())), __LINE__);
        }
        $this->voucherActionType = $voucherActionType;
        return $this;
    }
    /**
     * Get voucherQuantity value
     * @return string|null
     */
    public function getVoucherQuantity()
    {
        return $this->voucherQuantity;
    }
    /**
     * Set voucherQuantity value
     * @param string $voucherQuantity
     * @return \StructType\PrepaidVoucherImpl
     */
    public function setVoucherQuantity($voucherQuantity = null)
    {
        // validation for constraint: string
        if (!is_null($voucherQuantity) && !is_string($voucherQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voucherQuantity)), __LINE__);
        }
        $this->voucherQuantity = $voucherQuantity;
        return $this;
    }
    /**
     * Get thirtyDayExtQty value
     * @return string|null
     */
    public function getThirtyDayExtQty()
    {
        return $this->thirtyDayExtQty;
    }
    /**
     * Set thirtyDayExtQty value
     * @param string $thirtyDayExtQty
     * @return \StructType\PrepaidVoucherImpl
     */
    public function setThirtyDayExtQty($thirtyDayExtQty = null)
    {
        // validation for constraint: string
        if (!is_null($thirtyDayExtQty) && !is_string($thirtyDayExtQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($thirtyDayExtQty)), __LINE__);
        }
        $this->thirtyDayExtQty = $thirtyDayExtQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepaidVoucherImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
