<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for prepaid StructType
 * @subpackage Structs
 */
class Prepaid extends AbstractStructBase
{
    /**
     * The plan
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $plan;
    /**
     * Constructor method for prepaid
     * @uses Prepaid::setPlan()
     * @param string[] $plan
     */
    public function __construct(array $plan = array())
    {
        $this
            ->setPlan($plan);
    }
    /**
     * Get plan value
     * @return string[]|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @throws \InvalidArgumentException
     * @param string[] $plan
     * @return \StructType\Prepaid
     */
    public function setPlan(array $plan = array())
    {
        foreach ($plan as $prepaidPlanItem) {
            // validation for constraint: itemType
            if (!is_string($prepaidPlanItem)) {
                throw new \InvalidArgumentException(sprintf('The plan property can only contain items of string, "%s" given', is_object($prepaidPlanItem) ? get_class($prepaidPlanItem) : gettype($prepaidPlanItem)), __LINE__);
            }
        }
        $this->plan = $plan;
        return $this;
    }
    /**
     * Add item to plan value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Prepaid
     */
    public function addToPlan($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The plan property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->plan[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Prepaid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
