<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pagingSubscriberAccountImpl StructType
 * @subpackage Structs
 */
class PagingSubscriberAccountImpl extends AbsSubscriberAccountImpl
{
    /**
     * The commitmentStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commitmentStart;
    /**
     * The commitmentEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $commitmentEnd;
    /**
     * The plan
     * @var \StructType\PagingPlanImpl
     */
    public $plan;
    /**
     * The capcode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DeviceCapcodeImpl
     */
    public $capcode;
    /**
     * The isdna
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DeviceNumberImpl
     */
    public $isdna;
    /**
     * The mtd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mtd;
    /**
     * The mdas
     * @var \StructType\Mdas
     */
    public $mdas;
    /**
     * The subscriberAccountMetadata
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PagingSubscriberAccountMetadataImpl
     */
    public $subscriberAccountMetadata;
    /**
     * The followMePagingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $followMePagingNumber;
    /**
     * Constructor method for pagingSubscriberAccountImpl
     * @uses PagingSubscriberAccountImpl::setCommitmentStart()
     * @uses PagingSubscriberAccountImpl::setCommitmentEnd()
     * @uses PagingSubscriberAccountImpl::setPlan()
     * @uses PagingSubscriberAccountImpl::setCapcode()
     * @uses PagingSubscriberAccountImpl::setIsdna()
     * @uses PagingSubscriberAccountImpl::setMtd()
     * @uses PagingSubscriberAccountImpl::setMdas()
     * @uses PagingSubscriberAccountImpl::setSubscriberAccountMetadata()
     * @uses PagingSubscriberAccountImpl::setFollowMePagingNumber()
     * @param string $commitmentStart
     * @param string $commitmentEnd
     * @param \StructType\PagingPlanImpl $plan
     * @param \StructType\DeviceCapcodeImpl $capcode
     * @param \StructType\DeviceNumberImpl $isdna
     * @param string $mtd
     * @param \StructType\Mdas $mdas
     * @param \StructType\PagingSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @param string $followMePagingNumber
     */
    public function __construct($commitmentStart = null, $commitmentEnd = null, \StructType\PagingPlanImpl $plan = null, \StructType\DeviceCapcodeImpl $capcode = null, \StructType\DeviceNumberImpl $isdna = null, $mtd = null, \StructType\Mdas $mdas = null, \StructType\PagingSubscriberAccountMetadataImpl $subscriberAccountMetadata = null, $followMePagingNumber = null)
    {
        $this
            ->setCommitmentStart($commitmentStart)
            ->setCommitmentEnd($commitmentEnd)
            ->setPlan($plan)
            ->setCapcode($capcode)
            ->setIsdna($isdna)
            ->setMtd($mtd)
            ->setMdas($mdas)
            ->setSubscriberAccountMetadata($subscriberAccountMetadata)
            ->setFollowMePagingNumber($followMePagingNumber);
    }
    /**
     * Get commitmentStart value
     * @return string|null
     */
    public function getCommitmentStart()
    {
        return $this->commitmentStart;
    }
    /**
     * Set commitmentStart value
     * @param string $commitmentStart
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setCommitmentStart($commitmentStart = null)
    {
        // validation for constraint: string
        if (!is_null($commitmentStart) && !is_string($commitmentStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commitmentStart)), __LINE__);
        }
        $this->commitmentStart = $commitmentStart;
        return $this;
    }
    /**
     * Get commitmentEnd value
     * @return string|null
     */
    public function getCommitmentEnd()
    {
        return $this->commitmentEnd;
    }
    /**
     * Set commitmentEnd value
     * @param string $commitmentEnd
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setCommitmentEnd($commitmentEnd = null)
    {
        // validation for constraint: string
        if (!is_null($commitmentEnd) && !is_string($commitmentEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commitmentEnd)), __LINE__);
        }
        $this->commitmentEnd = $commitmentEnd;
        return $this;
    }
    /**
     * Get plan value
     * @return \StructType\PagingPlanImpl|null
     */
    public function getPlan()
    {
        return $this->plan;
    }
    /**
     * Set plan value
     * @param \StructType\PagingPlanImpl $plan
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setPlan(\StructType\PagingPlanImpl $plan = null)
    {
        $this->plan = $plan;
        return $this;
    }
    /**
     * Get capcode value
     * @return \StructType\DeviceCapcodeImpl|null
     */
    public function getCapcode()
    {
        return $this->capcode;
    }
    /**
     * Set capcode value
     * @param \StructType\DeviceCapcodeImpl $capcode
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setCapcode(\StructType\DeviceCapcodeImpl $capcode = null)
    {
        $this->capcode = $capcode;
        return $this;
    }
    /**
     * Get isdna value
     * @return \StructType\DeviceNumberImpl|null
     */
    public function getIsdna()
    {
        return $this->isdna;
    }
    /**
     * Set isdna value
     * @param \StructType\DeviceNumberImpl $isdna
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setIsdna(\StructType\DeviceNumberImpl $isdna = null)
    {
        $this->isdna = $isdna;
        return $this;
    }
    /**
     * Get mtd value
     * @return string|null
     */
    public function getMtd()
    {
        return $this->mtd;
    }
    /**
     * Set mtd value
     * @param string $mtd
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setMtd($mtd = null)
    {
        // validation for constraint: string
        if (!is_null($mtd) && !is_string($mtd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mtd)), __LINE__);
        }
        $this->mtd = $mtd;
        return $this;
    }
    /**
     * Get mdas value
     * @return \StructType\Mdas|null
     */
    public function getMdas()
    {
        return $this->mdas;
    }
    /**
     * Set mdas value
     * @param \StructType\Mdas $mdas
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setMdas(\StructType\Mdas $mdas = null)
    {
        $this->mdas = $mdas;
        return $this;
    }
    /**
     * Get subscriberAccountMetadata value
     * @return \StructType\PagingSubscriberAccountMetadataImpl|null
     */
    public function getSubscriberAccountMetadata()
    {
        return $this->subscriberAccountMetadata;
    }
    /**
     * Set subscriberAccountMetadata value
     * @param \StructType\PagingSubscriberAccountMetadataImpl $subscriberAccountMetadata
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setSubscriberAccountMetadata(\StructType\PagingSubscriberAccountMetadataImpl $subscriberAccountMetadata = null)
    {
        $this->subscriberAccountMetadata = $subscriberAccountMetadata;
        return $this;
    }
    /**
     * Get followMePagingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFollowMePagingNumber()
    {
        return isset($this->followMePagingNumber) ? $this->followMePagingNumber : null;
    }
    /**
     * Set followMePagingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $followMePagingNumber
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public function setFollowMePagingNumber($followMePagingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($followMePagingNumber) && !is_string($followMePagingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($followMePagingNumber)), __LINE__);
        }
        if (is_null($followMePagingNumber) || (is_array($followMePagingNumber) && empty($followMePagingNumber))) {
            unset($this->followMePagingNumber);
        } else {
            $this->followMePagingNumber = $followMePagingNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PagingSubscriberAccountImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
