<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for optionalGroupImpl StructType
 * @subpackage Structs
 */
class OptionalGroupImpl extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The maxNum
     * @var int
     */
    public $maxNum;
    /**
     * Constructor method for optionalGroupImpl
     * @uses OptionalGroupImpl::setName()
     * @uses OptionalGroupImpl::setMaxNum()
     * @param string $name
     * @param int $maxNum
     */
    public function __construct($name = null, $maxNum = null)
    {
        $this
            ->setName($name)
            ->setMaxNum($maxNum);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\OptionalGroupImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get maxNum value
     * @return int|null
     */
    public function getMaxNum()
    {
        return $this->maxNum;
    }
    /**
     * Set maxNum value
     * @param int $maxNum
     * @return \StructType\OptionalGroupImpl
     */
    public function setMaxNum($maxNum = null)
    {
        // validation for constraint: int
        if (!is_null($maxNum) && !is_numeric($maxNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNum)), __LINE__);
        }
        $this->maxNum = $maxNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OptionalGroupImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
