<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for openPortPlanImpl StructType
 * @subpackage Structs
 */
class OpenPortPlanImpl extends AbsPlanImpl
{
    /**
     * The paymentModel
     * @var string
     */
    public $paymentModel;
    /**
     * The voiceBundleId
     * @var string
     */
    public $voiceBundleId;
    /**
     * The dataBundleId
     * @var string
     */
    public $dataBundleId;
    /**
     * The dataSpeedBundleId
     * @var string
     */
    public $dataSpeedBundleId;
    /**
     * The vcsBundleId
     * @var string
     */
    public $vcsBundleId;
    /**
     * The commitmentPeriodBundleId
     * @var string
     */
    public $commitmentPeriodBundleId;
    /**
     * The languageBundleId
     * @var string
     */
    public $languageBundleId;
    /**
     * The simLock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $simLock;
    /**
     * Constructor method for openPortPlanImpl
     * @uses OpenPortPlanImpl::setPaymentModel()
     * @uses OpenPortPlanImpl::setVoiceBundleId()
     * @uses OpenPortPlanImpl::setDataBundleId()
     * @uses OpenPortPlanImpl::setDataSpeedBundleId()
     * @uses OpenPortPlanImpl::setVcsBundleId()
     * @uses OpenPortPlanImpl::setCommitmentPeriodBundleId()
     * @uses OpenPortPlanImpl::setLanguageBundleId()
     * @uses OpenPortPlanImpl::setSimLock()
     * @param string $paymentModel
     * @param string $voiceBundleId
     * @param string $dataBundleId
     * @param string $dataSpeedBundleId
     * @param string $vcsBundleId
     * @param string $commitmentPeriodBundleId
     * @param string $languageBundleId
     * @param string $simLock
     */
    public function __construct($paymentModel = null, $voiceBundleId = null, $dataBundleId = null, $dataSpeedBundleId = null, $vcsBundleId = null, $commitmentPeriodBundleId = null, $languageBundleId = null, $simLock = null)
    {
        $this
            ->setPaymentModel($paymentModel)
            ->setVoiceBundleId($voiceBundleId)
            ->setDataBundleId($dataBundleId)
            ->setDataSpeedBundleId($dataSpeedBundleId)
            ->setVcsBundleId($vcsBundleId)
            ->setCommitmentPeriodBundleId($commitmentPeriodBundleId)
            ->setLanguageBundleId($languageBundleId)
            ->setSimLock($simLock);
    }
    /**
     * Get paymentModel value
     * @return string|null
     */
    public function getPaymentModel()
    {
        return $this->paymentModel;
    }
    /**
     * Set paymentModel value
     * @uses \EnumType\PaymentModelTypeEnum::valueIsValid()
     * @uses \EnumType\PaymentModelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentModel
     * @return \StructType\OpenPortPlanImpl
     */
    public function setPaymentModel($paymentModel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentModelTypeEnum::valueIsValid($paymentModel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentModel, implode(', ', \EnumType\PaymentModelTypeEnum::getValidValues())), __LINE__);
        }
        $this->paymentModel = $paymentModel;
        return $this;
    }
    /**
     * Get voiceBundleId value
     * @return string|null
     */
    public function getVoiceBundleId()
    {
        return $this->voiceBundleId;
    }
    /**
     * Set voiceBundleId value
     * @param string $voiceBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setVoiceBundleId($voiceBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($voiceBundleId) && !is_string($voiceBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceBundleId)), __LINE__);
        }
        $this->voiceBundleId = $voiceBundleId;
        return $this;
    }
    /**
     * Get dataBundleId value
     * @return string|null
     */
    public function getDataBundleId()
    {
        return $this->dataBundleId;
    }
    /**
     * Set dataBundleId value
     * @param string $dataBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setDataBundleId($dataBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($dataBundleId) && !is_string($dataBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataBundleId)), __LINE__);
        }
        $this->dataBundleId = $dataBundleId;
        return $this;
    }
    /**
     * Get dataSpeedBundleId value
     * @return string|null
     */
    public function getDataSpeedBundleId()
    {
        return $this->dataSpeedBundleId;
    }
    /**
     * Set dataSpeedBundleId value
     * @param string $dataSpeedBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setDataSpeedBundleId($dataSpeedBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($dataSpeedBundleId) && !is_string($dataSpeedBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataSpeedBundleId)), __LINE__);
        }
        $this->dataSpeedBundleId = $dataSpeedBundleId;
        return $this;
    }
    /**
     * Get vcsBundleId value
     * @return string|null
     */
    public function getVcsBundleId()
    {
        return $this->vcsBundleId;
    }
    /**
     * Set vcsBundleId value
     * @param string $vcsBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setVcsBundleId($vcsBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($vcsBundleId) && !is_string($vcsBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vcsBundleId)), __LINE__);
        }
        $this->vcsBundleId = $vcsBundleId;
        return $this;
    }
    /**
     * Get commitmentPeriodBundleId value
     * @return string|null
     */
    public function getCommitmentPeriodBundleId()
    {
        return $this->commitmentPeriodBundleId;
    }
    /**
     * Set commitmentPeriodBundleId value
     * @param string $commitmentPeriodBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setCommitmentPeriodBundleId($commitmentPeriodBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($commitmentPeriodBundleId) && !is_string($commitmentPeriodBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commitmentPeriodBundleId)), __LINE__);
        }
        $this->commitmentPeriodBundleId = $commitmentPeriodBundleId;
        return $this;
    }
    /**
     * Get languageBundleId value
     * @return string|null
     */
    public function getLanguageBundleId()
    {
        return $this->languageBundleId;
    }
    /**
     * Set languageBundleId value
     * @param string $languageBundleId
     * @return \StructType\OpenPortPlanImpl
     */
    public function setLanguageBundleId($languageBundleId = null)
    {
        // validation for constraint: string
        if (!is_null($languageBundleId) && !is_string($languageBundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($languageBundleId)), __LINE__);
        }
        $this->languageBundleId = $languageBundleId;
        return $this;
    }
    /**
     * Get simLock value
     * @return string|null
     */
    public function getSimLock()
    {
        return $this->simLock;
    }
    /**
     * Set simLock value
     * @param string $simLock
     * @return \StructType\OpenPortPlanImpl
     */
    public function setSimLock($simLock = null)
    {
        // validation for constraint: string
        if (!is_null($simLock) && !is_string($simLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($simLock)), __LINE__);
        }
        $this->simLock = $simLock;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpenPortPlanImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
