<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for openPortDeviceNumberImpl StructType
 * @subpackage Structs
 */
class OpenPortDeviceNumberImpl extends DeviceNumberImpl
{
    /**
     * The voiceChannel
     * @var int
     */
    public $voiceChannel;
    /**
     * The lineType
     * @var string
     */
    public $lineType;
    /**
     * The voiceMail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $voiceMail;
    /**
     * The captainPinEnable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $captainPinEnable;
    /**
     * The captainPin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $captainPin;
    /**
     * The twoStageEnable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $twoStageEnable;
    /**
     * The twoStagePin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $twoStagePin;
    /**
     * The plusOneEnable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plusOneEnable;
    /**
     * The plusOneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plusOneNumber;
    /**
     * The programmableButtons
     * @var \StructType\ProgrammableButtons
     */
    public $programmableButtons;
    /**
     * Constructor method for openPortDeviceNumberImpl
     * @uses OpenPortDeviceNumberImpl::setVoiceChannel()
     * @uses OpenPortDeviceNumberImpl::setLineType()
     * @uses OpenPortDeviceNumberImpl::setVoiceMail()
     * @uses OpenPortDeviceNumberImpl::setCaptainPinEnable()
     * @uses OpenPortDeviceNumberImpl::setCaptainPin()
     * @uses OpenPortDeviceNumberImpl::setTwoStageEnable()
     * @uses OpenPortDeviceNumberImpl::setTwoStagePin()
     * @uses OpenPortDeviceNumberImpl::setPlusOneEnable()
     * @uses OpenPortDeviceNumberImpl::setPlusOneNumber()
     * @uses OpenPortDeviceNumberImpl::setProgrammableButtons()
     * @param int $voiceChannel
     * @param string $lineType
     * @param string $voiceMail
     * @param string $captainPinEnable
     * @param string $captainPin
     * @param string $twoStageEnable
     * @param string $twoStagePin
     * @param string $plusOneEnable
     * @param string $plusOneNumber
     * @param \StructType\ProgrammableButtons $programmableButtons
     */
    public function __construct($voiceChannel = null, $lineType = null, $voiceMail = null, $captainPinEnable = null, $captainPin = null, $twoStageEnable = null, $twoStagePin = null, $plusOneEnable = null, $plusOneNumber = null, \StructType\ProgrammableButtons $programmableButtons = null)
    {
        $this
            ->setVoiceChannel($voiceChannel)
            ->setLineType($lineType)
            ->setVoiceMail($voiceMail)
            ->setCaptainPinEnable($captainPinEnable)
            ->setCaptainPin($captainPin)
            ->setTwoStageEnable($twoStageEnable)
            ->setTwoStagePin($twoStagePin)
            ->setPlusOneEnable($plusOneEnable)
            ->setPlusOneNumber($plusOneNumber)
            ->setProgrammableButtons($programmableButtons);
    }
    /**
     * Get voiceChannel value
     * @return int|null
     */
    public function getVoiceChannel()
    {
        return $this->voiceChannel;
    }
    /**
     * Set voiceChannel value
     * @param int $voiceChannel
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setVoiceChannel($voiceChannel = null)
    {
        // validation for constraint: int
        if (!is_null($voiceChannel) && !is_numeric($voiceChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($voiceChannel)), __LINE__);
        }
        $this->voiceChannel = $voiceChannel;
        return $this;
    }
    /**
     * Get lineType value
     * @return string|null
     */
    public function getLineType()
    {
        return $this->lineType;
    }
    /**
     * Set lineType value
     * @uses \EnumType\LineTypeEnum::valueIsValid()
     * @uses \EnumType\LineTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineType
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setLineType($lineType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LineTypeEnum::valueIsValid($lineType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lineType, implode(', ', \EnumType\LineTypeEnum::getValidValues())), __LINE__);
        }
        $this->lineType = $lineType;
        return $this;
    }
    /**
     * Get voiceMail value
     * @return string|null
     */
    public function getVoiceMail()
    {
        return $this->voiceMail;
    }
    /**
     * Set voiceMail value
     * @param string $voiceMail
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setVoiceMail($voiceMail = null)
    {
        // validation for constraint: string
        if (!is_null($voiceMail) && !is_string($voiceMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($voiceMail)), __LINE__);
        }
        $this->voiceMail = $voiceMail;
        return $this;
    }
    /**
     * Get captainPinEnable value
     * @return string|null
     */
    public function getCaptainPinEnable()
    {
        return $this->captainPinEnable;
    }
    /**
     * Set captainPinEnable value
     * @param string $captainPinEnable
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setCaptainPinEnable($captainPinEnable = null)
    {
        // validation for constraint: string
        if (!is_null($captainPinEnable) && !is_string($captainPinEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($captainPinEnable)), __LINE__);
        }
        $this->captainPinEnable = $captainPinEnable;
        return $this;
    }
    /**
     * Get captainPin value
     * @return string|null
     */
    public function getCaptainPin()
    {
        return $this->captainPin;
    }
    /**
     * Set captainPin value
     * @param string $captainPin
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setCaptainPin($captainPin = null)
    {
        // validation for constraint: string
        if (!is_null($captainPin) && !is_string($captainPin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($captainPin)), __LINE__);
        }
        $this->captainPin = $captainPin;
        return $this;
    }
    /**
     * Get twoStageEnable value
     * @return string|null
     */
    public function getTwoStageEnable()
    {
        return $this->twoStageEnable;
    }
    /**
     * Set twoStageEnable value
     * @param string $twoStageEnable
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setTwoStageEnable($twoStageEnable = null)
    {
        // validation for constraint: string
        if (!is_null($twoStageEnable) && !is_string($twoStageEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoStageEnable)), __LINE__);
        }
        $this->twoStageEnable = $twoStageEnable;
        return $this;
    }
    /**
     * Get twoStagePin value
     * @return string|null
     */
    public function getTwoStagePin()
    {
        return $this->twoStagePin;
    }
    /**
     * Set twoStagePin value
     * @param string $twoStagePin
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setTwoStagePin($twoStagePin = null)
    {
        // validation for constraint: string
        if (!is_null($twoStagePin) && !is_string($twoStagePin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoStagePin)), __LINE__);
        }
        $this->twoStagePin = $twoStagePin;
        return $this;
    }
    /**
     * Get plusOneEnable value
     * @return string|null
     */
    public function getPlusOneEnable()
    {
        return $this->plusOneEnable;
    }
    /**
     * Set plusOneEnable value
     * @param string $plusOneEnable
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setPlusOneEnable($plusOneEnable = null)
    {
        // validation for constraint: string
        if (!is_null($plusOneEnable) && !is_string($plusOneEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plusOneEnable)), __LINE__);
        }
        $this->plusOneEnable = $plusOneEnable;
        return $this;
    }
    /**
     * Get plusOneNumber value
     * @return string|null
     */
    public function getPlusOneNumber()
    {
        return $this->plusOneNumber;
    }
    /**
     * Set plusOneNumber value
     * @param string $plusOneNumber
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setPlusOneNumber($plusOneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($plusOneNumber) && !is_string($plusOneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($plusOneNumber)), __LINE__);
        }
        $this->plusOneNumber = $plusOneNumber;
        return $this;
    }
    /**
     * Get programmableButtons value
     * @return \StructType\ProgrammableButtons|null
     */
    public function getProgrammableButtons()
    {
        return $this->programmableButtons;
    }
    /**
     * Set programmableButtons value
     * @param \StructType\ProgrammableButtons $programmableButtons
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public function setProgrammableButtons(\StructType\ProgrammableButtons $programmableButtons = null)
    {
        $this->programmableButtons = $programmableButtons;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpenPortDeviceNumberImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
