<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for notifications StructType
 * @subpackage Structs
 */
class Notifications extends AbstractStructBase
{
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ActionNotificationImpl[]
     */
    public $action;
    /**
     * Constructor method for notifications
     * @uses Notifications::setAction()
     * @param \StructType\ActionNotificationImpl[] $action
     */
    public function __construct(array $action = array())
    {
        $this
            ->setAction($action);
    }
    /**
     * Get action value
     * @return \StructType\ActionNotificationImpl[]|null
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionNotificationImpl[] $action
     * @return \StructType\Notifications
     */
    public function setAction(array $action = array())
    {
        foreach ($action as $notificationsActionItem) {
            // validation for constraint: itemType
            if (!$notificationsActionItem instanceof \StructType\ActionNotificationImpl) {
                throw new \InvalidArgumentException(sprintf('The action property can only contain items of \StructType\ActionNotificationImpl, "%s" given', is_object($notificationsActionItem) ? get_class($notificationsActionItem) : gettype($notificationsActionItem)), __LINE__);
            }
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Add item to action value
     * @throws \InvalidArgumentException
     * @param \StructType\ActionNotificationImpl $item
     * @return \StructType\Notifications
     */
    public function addToAction(\StructType\ActionNotificationImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ActionNotificationImpl) {
            throw new \InvalidArgumentException(sprintf('The action property can only contain items of \StructType\ActionNotificationImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->action[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Notifications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
