<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mtFilterImpl StructType
 * @subpackage Structs
 */
class MtFilterImpl extends AbstractStructBase
{
    /**
     * The ruleType
     * @var string
     */
    public $ruleType;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * Constructor method for mtFilterImpl
     * @uses MtFilterImpl::setRuleType()
     * @uses MtFilterImpl::setAddress()
     * @param string $ruleType
     * @param string $address
     */
    public function __construct($ruleType = null, $address = null)
    {
        $this
            ->setRuleType($ruleType)
            ->setAddress($address);
    }
    /**
     * Get ruleType value
     * @return string|null
     */
    public function getRuleType()
    {
        return $this->ruleType;
    }
    /**
     * Set ruleType value
     * @uses \EnumType\MtFilterRuleTypeEnum::valueIsValid()
     * @uses \EnumType\MtFilterRuleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ruleType
     * @return \StructType\MtFilterImpl
     */
    public function setRuleType($ruleType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MtFilterRuleTypeEnum::valueIsValid($ruleType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ruleType, implode(', ', \EnumType\MtFilterRuleTypeEnum::getValidValues())), __LINE__);
        }
        $this->ruleType = $ruleType;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\MtFilterImpl
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MtFilterImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
