<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moipQueueReportEntryImpl StructType
 * @subpackage Structs
 */
class MoipQueueReportEntryImpl extends AbstractStructBase
{
    /**
     * The messageCount
     * @var int
     */
    public $messageCount;
    /**
     * The deliveryMethodType
     * @var string
     */
    public $deliveryMethodType;
    /**
     * The deliveryTo
     * @var string
     */
    public $deliveryTo;
    /**
     * The deliveryStatusType
     * @var string
     */
    public $deliveryStatusType;
    /**
     * Constructor method for moipQueueReportEntryImpl
     * @uses MoipQueueReportEntryImpl::setMessageCount()
     * @uses MoipQueueReportEntryImpl::setDeliveryMethodType()
     * @uses MoipQueueReportEntryImpl::setDeliveryTo()
     * @uses MoipQueueReportEntryImpl::setDeliveryStatusType()
     * @param int $messageCount
     * @param string $deliveryMethodType
     * @param string $deliveryTo
     * @param string $deliveryStatusType
     */
    public function __construct($messageCount = null, $deliveryMethodType = null, $deliveryTo = null, $deliveryStatusType = null)
    {
        $this
            ->setMessageCount($messageCount)
            ->setDeliveryMethodType($deliveryMethodType)
            ->setDeliveryTo($deliveryTo)
            ->setDeliveryStatusType($deliveryStatusType);
    }
    /**
     * Get messageCount value
     * @return int|null
     */
    public function getMessageCount()
    {
        return $this->messageCount;
    }
    /**
     * Set messageCount value
     * @param int $messageCount
     * @return \StructType\MoipQueueReportEntryImpl
     */
    public function setMessageCount($messageCount = null)
    {
        // validation for constraint: int
        if (!is_null($messageCount) && !is_numeric($messageCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageCount)), __LINE__);
        }
        $this->messageCount = $messageCount;
        return $this;
    }
    /**
     * Get deliveryMethodType value
     * @return string|null
     */
    public function getDeliveryMethodType()
    {
        return $this->deliveryMethodType;
    }
    /**
     * Set deliveryMethodType value
     * @uses \EnumType\DeliveryMethodTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryMethodTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryMethodType
     * @return \StructType\MoipQueueReportEntryImpl
     */
    public function setDeliveryMethodType($deliveryMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryMethodTypeEnum::valueIsValid($deliveryMethodType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryMethodType, implode(', ', \EnumType\DeliveryMethodTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryMethodType = $deliveryMethodType;
        return $this;
    }
    /**
     * Get deliveryTo value
     * @return string|null
     */
    public function getDeliveryTo()
    {
        return $this->deliveryTo;
    }
    /**
     * Set deliveryTo value
     * @param string $deliveryTo
     * @return \StructType\MoipQueueReportEntryImpl
     */
    public function setDeliveryTo($deliveryTo = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryTo) && !is_string($deliveryTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryTo)), __LINE__);
        }
        $this->deliveryTo = $deliveryTo;
        return $this;
    }
    /**
     * Get deliveryStatusType value
     * @return string|null
     */
    public function getDeliveryStatusType()
    {
        return $this->deliveryStatusType;
    }
    /**
     * Set deliveryStatusType value
     * @uses \EnumType\DeliveryStatusTypeEnum::valueIsValid()
     * @uses \EnumType\DeliveryStatusTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deliveryStatusType
     * @return \StructType\MoipQueueReportEntryImpl
     */
    public function setDeliveryStatusType($deliveryStatusType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeliveryStatusTypeEnum::valueIsValid($deliveryStatusType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $deliveryStatusType, implode(', ', \EnumType\DeliveryStatusTypeEnum::getValidValues())), __LINE__);
        }
        $this->deliveryStatusType = $deliveryStatusType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoipQueueReportEntryImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
