<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for models StructType
 * @subpackage Structs
 */
class Models extends AbstractStructBase
{
    /**
     * The model
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SimplifiedModelImpl[]
     */
    public $model;
    /**
     * Constructor method for models
     * @uses Models::setModel()
     * @param \StructType\SimplifiedModelImpl[] $model
     */
    public function __construct(array $model = array())
    {
        $this
            ->setModel($model);
    }
    /**
     * Get model value
     * @return \StructType\SimplifiedModelImpl[]|null
     */
    public function getModel()
    {
        return $this->model;
    }
    /**
     * Set model value
     * @throws \InvalidArgumentException
     * @param \StructType\SimplifiedModelImpl[] $model
     * @return \StructType\Models
     */
    public function setModel(array $model = array())
    {
        foreach ($model as $modelsModelItem) {
            // validation for constraint: itemType
            if (!$modelsModelItem instanceof \StructType\SimplifiedModelImpl) {
                throw new \InvalidArgumentException(sprintf('The model property can only contain items of \StructType\SimplifiedModelImpl, "%s" given', is_object($modelsModelItem) ? get_class($modelsModelItem) : gettype($modelsModelItem)), __LINE__);
            }
        }
        $this->model = $model;
        return $this;
    }
    /**
     * Add item to model value
     * @throws \InvalidArgumentException
     * @param \StructType\SimplifiedModelImpl $item
     * @return \StructType\Models
     */
    public function addToModel(\StructType\SimplifiedModelImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SimplifiedModelImpl) {
            throw new \InvalidArgumentException(sprintf('The model property can only contain items of \StructType\SimplifiedModelImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->model[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Models
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
