<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for memberAccounts StructType
 * @subpackage Structs
 */
class MemberAccounts extends AbstractStructBase
{
    /**
     * The memberAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubscriberAccountEntryImpl[]
     */
    public $memberAccount;
    /**
     * Constructor method for memberAccounts
     * @uses MemberAccounts::setMemberAccount()
     * @param \StructType\SubscriberAccountEntryImpl[] $memberAccount
     */
    public function __construct(array $memberAccount = array())
    {
        $this
            ->setMemberAccount($memberAccount);
    }
    /**
     * Get memberAccount value
     * @return \StructType\SubscriberAccountEntryImpl[]|null
     */
    public function getMemberAccount()
    {
        return $this->memberAccount;
    }
    /**
     * Set memberAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriberAccountEntryImpl[] $memberAccount
     * @return \StructType\MemberAccounts
     */
    public function setMemberAccount(array $memberAccount = array())
    {
        foreach ($memberAccount as $memberAccountsMemberAccountItem) {
            // validation for constraint: itemType
            if (!$memberAccountsMemberAccountItem instanceof \StructType\SubscriberAccountEntryImpl) {
                throw new \InvalidArgumentException(sprintf('The memberAccount property can only contain items of \StructType\SubscriberAccountEntryImpl, "%s" given', is_object($memberAccountsMemberAccountItem) ? get_class($memberAccountsMemberAccountItem) : gettype($memberAccountsMemberAccountItem)), __LINE__);
            }
        }
        $this->memberAccount = $memberAccount;
        return $this;
    }
    /**
     * Add item to memberAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\SubscriberAccountEntryImpl $item
     * @return \StructType\MemberAccounts
     */
    public function addToMemberAccount(\StructType\SubscriberAccountEntryImpl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubscriberAccountEntryImpl) {
            throw new \InvalidArgumentException(sprintf('The memberAccount property can only contain items of \StructType\SubscriberAccountEntryImpl, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->memberAccount[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MemberAccounts
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
