<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mdas StructType
 * @subpackage Structs
 */
class Mdas extends AbstractStructBase
{
    /**
     * The mda
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $mda;
    /**
     * Constructor method for mdas
     * @uses Mdas::setMda()
     * @param string[] $mda
     */
    public function __construct(array $mda = array())
    {
        $this
            ->setMda($mda);
    }
    /**
     * Get mda value
     * @return string[]|null
     */
    public function getMda()
    {
        return $this->mda;
    }
    /**
     * Set mda value
     * @throws \InvalidArgumentException
     * @param string[] $mda
     * @return \StructType\Mdas
     */
    public function setMda(array $mda = array())
    {
        foreach ($mda as $mdasMdaItem) {
            // validation for constraint: itemType
            if (!is_string($mdasMdaItem)) {
                throw new \InvalidArgumentException(sprintf('The mda property can only contain items of string, "%s" given', is_object($mdasMdaItem) ? get_class($mdasMdaItem) : gettype($mdasMdaItem)), __LINE__);
            }
        }
        $this->mda = $mda;
        return $this;
    }
    /**
     * Add item to mda value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Mdas
     */
    public function addToMda($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The mda property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->mda[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Mdas
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
