<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for manufacturerImpl StructType
 * @subpackage Structs
 */
class ManufacturerImpl extends AbstractStructBase
{
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The verticals
     * @var \StructType\Verticals
     */
    public $verticals;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * Constructor method for manufacturerImpl
     * @uses ManufacturerImpl::setId()
     * @uses ManufacturerImpl::setName()
     * @uses ManufacturerImpl::setVerticals()
     * @uses ManufacturerImpl::setStatus()
     * @param string $id
     * @param string $name
     * @param \StructType\Verticals $verticals
     * @param string $status
     */
    public function __construct($id = null, $name = null, \StructType\Verticals $verticals = null, $status = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setVerticals($verticals)
            ->setStatus($status);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ManufacturerImpl
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ManufacturerImpl
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get verticals value
     * @return \StructType\Verticals|null
     */
    public function getVerticals()
    {
        return $this->verticals;
    }
    /**
     * Set verticals value
     * @param \StructType\Verticals $verticals
     * @return \StructType\ManufacturerImpl
     */
    public function setVerticals(\StructType\Verticals $verticals = null)
    {
        $this->verticals = $verticals;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ObjectStatusEnum::valueIsValid()
     * @uses \EnumType\ObjectStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ManufacturerImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ObjectStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ObjectStatusEnum::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ManufacturerImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
