<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for m2MImeiSearchRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:m2MImeiSearchRequestImpl
 * @subpackage Structs
 */
class M2MImeiSearchRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The IMEISearchString
     * @var string
     */
    public $IMEISearchString;
    /**
     * The status
     * @var string
     */
    public $status;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - default: 100
     * @var int
     */
    public $limit;
    /**
     * The startRow
     * Meta informations extracted from the WSDL
     * - default: 0
     * @var int
     */
    public $startRow;
    /**
     * Constructor method for m2MImeiSearchRequestImpl
     * @uses M2MImeiSearchRequestImpl::setIMEISearchString()
     * @uses M2MImeiSearchRequestImpl::setStatus()
     * @uses M2MImeiSearchRequestImpl::setLimit()
     * @uses M2MImeiSearchRequestImpl::setStartRow()
     * @param string $iMEISearchString
     * @param string $status
     * @param int $limit
     * @param int $startRow
     */
    public function __construct($iMEISearchString = null, $status = null, $limit = 100, $startRow = 0)
    {
        $this
            ->setIMEISearchString($iMEISearchString)
            ->setStatus($status)
            ->setLimit($limit)
            ->setStartRow($startRow);
    }
    /**
     * Get IMEISearchString value
     * @return string|null
     */
    public function getIMEISearchString()
    {
        return $this->IMEISearchString;
    }
    /**
     * Set IMEISearchString value
     * @param string $iMEISearchString
     * @return \StructType\M2MImeiSearchRequestImpl
     */
    public function setIMEISearchString($iMEISearchString = null)
    {
        // validation for constraint: string
        if (!is_null($iMEISearchString) && !is_string($iMEISearchString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iMEISearchString)), __LINE__);
        }
        $this->IMEISearchString = $iMEISearchString;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param string $status
     * @return \StructType\M2MImeiSearchRequestImpl
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\M2MImeiSearchRequestImpl
     */
    public function setLimit($limit = 100)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get startRow value
     * @return int|null
     */
    public function getStartRow()
    {
        return $this->startRow;
    }
    /**
     * Set startRow value
     * @param int $startRow
     * @return \StructType\M2MImeiSearchRequestImpl
     */
    public function setStartRow($startRow = 0)
    {
        // validation for constraint: int
        if (!is_null($startRow) && !is_numeric($startRow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startRow)), __LINE__);
        }
        $this->startRow = $startRow;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\M2MImeiSearchRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
