<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for grantRoleRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:grantRoleRequestImpl
 * @subpackage Structs
 */
class GrantRoleRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * The userName
     * @var string
     */
    public $userName;
    /**
     * Constructor method for grantRoleRequestImpl
     * @uses GrantRoleRequestImpl::setRole()
     * @uses GrantRoleRequestImpl::setUserName()
     * @param string $role
     * @param string $userName
     */
    public function __construct($role = null, $userName = null)
    {
        $this
            ->setRole($role)
            ->setUserName($userName);
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\RoleTypeEnum::valueIsValid()
     * @uses \EnumType\RoleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \StructType\GrantRoleRequestImpl
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RoleTypeEnum::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \EnumType\RoleTypeEnum::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\GrantRoleRequestImpl
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GrantRoleRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
