<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getSubscriberBaseReportResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getSubscriberBaseReportResponseImpl
 * @subpackage Structs
 */
class GetSubscriberBaseReportResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The subscribers
     * @var \StructType\Subscribers
     */
    public $subscribers;
    /**
     * Constructor method for getSubscriberBaseReportResponseImpl
     * @uses GetSubscriberBaseReportResponseImpl::setTotalNumberOfRecords()
     * @uses GetSubscriberBaseReportResponseImpl::setSubscribers()
     * @param int $totalNumberOfRecords
     * @param \StructType\Subscribers $subscribers
     */
    public function __construct($totalNumberOfRecords = null, \StructType\Subscribers $subscribers = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setSubscribers($subscribers);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetSubscriberBaseReportResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get subscribers value
     * @return \StructType\Subscribers|null
     */
    public function getSubscribers()
    {
        return $this->subscribers;
    }
    /**
     * Set subscribers value
     * @param \StructType\Subscribers $subscribers
     * @return \StructType\GetSubscriberBaseReportResponseImpl
     */
    public function setSubscribers(\StructType\Subscribers $subscribers = null)
    {
        $this->subscribers = $subscribers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubscriberBaseReportResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
