<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRudicsGroupsResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getRudicsGroupsResponseImpl
 * @subpackage Structs
 */
class GetRudicsGroupsResponseImpl extends IwsResponseImpl
{
    /**
     * The serviceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceType;
    /**
     * The rudicsGroups
     * @var \StructType\RudicsGroups
     */
    public $rudicsGroups;
    /**
     * Constructor method for getRudicsGroupsResponseImpl
     * @uses GetRudicsGroupsResponseImpl::setServiceType()
     * @uses GetRudicsGroupsResponseImpl::setRudicsGroups()
     * @param string $serviceType
     * @param \StructType\RudicsGroups $rudicsGroups
     */
    public function __construct($serviceType = null, \StructType\RudicsGroups $rudicsGroups = null)
    {
        $this
            ->setServiceType($serviceType)
            ->setRudicsGroups($rudicsGroups);
    }
    /**
     * Get serviceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->serviceType;
    }
    /**
     * Set serviceType value
     * @uses \EnumType\ServiceTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceType
     * @return \StructType\GetRudicsGroupsResponseImpl
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceTypeEnum::valueIsValid($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceType, implode(', ', \EnumType\ServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceType = $serviceType;
        return $this;
    }
    /**
     * Get rudicsGroups value
     * @return \StructType\RudicsGroups|null
     */
    public function getRudicsGroups()
    {
        return $this->rudicsGroups;
    }
    /**
     * Set rudicsGroups value
     * @param \StructType\RudicsGroups $rudicsGroups
     * @return \StructType\GetRudicsGroupsResponseImpl
     */
    public function setRudicsGroups(\StructType\RudicsGroups $rudicsGroups = null)
    {
        $this->rudicsGroups = $rudicsGroups;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRudicsGroupsResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
