<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getResourceInventoryReportResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getResourceInventoryReportResponseImpl
 * @subpackage Structs
 */
class GetResourceInventoryReportResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The resources
     * @var \StructType\Resources
     */
    public $resources;
    /**
     * Constructor method for getResourceInventoryReportResponseImpl
     * @uses GetResourceInventoryReportResponseImpl::setTotalNumberOfRecords()
     * @uses GetResourceInventoryReportResponseImpl::setResources()
     * @param int $totalNumberOfRecords
     * @param \StructType\Resources $resources
     */
    public function __construct($totalNumberOfRecords = null, \StructType\Resources $resources = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setResources($resources);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetResourceInventoryReportResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get resources value
     * @return \StructType\Resources|null
     */
    public function getResources()
    {
        return $this->resources;
    }
    /**
     * Set resources value
     * @param \StructType\Resources $resources
     * @return \StructType\GetResourceInventoryReportResponseImpl
     */
    public function setResources(\StructType\Resources $resources = null)
    {
        $this->resources = $resources;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetResourceInventoryReportResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
