<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrepaidPlansRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getPrepaidPlansRequestImpl
 * @subpackage Structs
 */
class GetPrepaidPlansRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The prepaidAccountType
     * @var string
     */
    public $prepaidAccountType;
    /**
     * The submarketId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $submarketId;
    /**
     * Constructor method for getPrepaidPlansRequestImpl
     * @uses GetPrepaidPlansRequestImpl::setPrepaidAccountType()
     * @uses GetPrepaidPlansRequestImpl::setSubmarketId()
     * @param string $prepaidAccountType
     * @param string $submarketId
     */
    public function __construct($prepaidAccountType = null, $submarketId = null)
    {
        $this
            ->setPrepaidAccountType($prepaidAccountType)
            ->setSubmarketId($submarketId);
    }
    /**
     * Get prepaidAccountType value
     * @return string|null
     */
    public function getPrepaidAccountType()
    {
        return $this->prepaidAccountType;
    }
    /**
     * Set prepaidAccountType value
     * @uses \EnumType\PrepaidAccountTypeEnum::valueIsValid()
     * @uses \EnumType\PrepaidAccountTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prepaidAccountType
     * @return \StructType\GetPrepaidPlansRequestImpl
     */
    public function setPrepaidAccountType($prepaidAccountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PrepaidAccountTypeEnum::valueIsValid($prepaidAccountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $prepaidAccountType, implode(', ', \EnumType\PrepaidAccountTypeEnum::getValidValues())), __LINE__);
        }
        $this->prepaidAccountType = $prepaidAccountType;
        return $this;
    }
    /**
     * Get submarketId value
     * @return string|null
     */
    public function getSubmarketId()
    {
        return $this->submarketId;
    }
    /**
     * Set submarketId value
     * @param string $submarketId
     * @return \StructType\GetPrepaidPlansRequestImpl
     */
    public function setSubmarketId($submarketId = null)
    {
        // validation for constraint: string
        if (!is_null($submarketId) && !is_string($submarketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($submarketId)), __LINE__);
        }
        $this->submarketId = $submarketId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPrepaidPlansRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
