<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrepaidCallHistoryResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getPrepaidCallHistoryResponseImpl
 * @subpackage Structs
 */
class GetPrepaidCallHistoryResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The prepaidCallHistoryDetails
     * @var \StructType\PrepaidCallHistoryDetails
     */
    public $prepaidCallHistoryDetails;
    /**
     * Constructor method for getPrepaidCallHistoryResponseImpl
     * @uses GetPrepaidCallHistoryResponseImpl::setTotalNumberOfRecords()
     * @uses GetPrepaidCallHistoryResponseImpl::setPrepaidCallHistoryDetails()
     * @param int $totalNumberOfRecords
     * @param \StructType\PrepaidCallHistoryDetails $prepaidCallHistoryDetails
     */
    public function __construct($totalNumberOfRecords = null, \StructType\PrepaidCallHistoryDetails $prepaidCallHistoryDetails = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setPrepaidCallHistoryDetails($prepaidCallHistoryDetails);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetPrepaidCallHistoryResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get prepaidCallHistoryDetails value
     * @return \StructType\PrepaidCallHistoryDetails|null
     */
    public function getPrepaidCallHistoryDetails()
    {
        return $this->prepaidCallHistoryDetails;
    }
    /**
     * Set prepaidCallHistoryDetails value
     * @param \StructType\PrepaidCallHistoryDetails $prepaidCallHistoryDetails
     * @return \StructType\GetPrepaidCallHistoryResponseImpl
     */
    public function setPrepaidCallHistoryDetails(\StructType\PrepaidCallHistoryDetails $prepaidCallHistoryDetails = null)
    {
        $this->prepaidCallHistoryDetails = $prepaidCallHistoryDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPrepaidCallHistoryResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
