<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPrepaidAccountSummaryResponseImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getPrepaidAccountSummaryResponseImpl
 * @subpackage Structs
 */
class GetPrepaidAccountSummaryResponseImpl extends IwsResponseImpl
{
    /**
     * The totalNumberOfRecords
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $totalNumberOfRecords;
    /**
     * The prepaidAccountSummaryDetails
     * @var \StructType\PrepaidAccountSummaryDetails
     */
    public $prepaidAccountSummaryDetails;
    /**
     * Constructor method for getPrepaidAccountSummaryResponseImpl
     * @uses GetPrepaidAccountSummaryResponseImpl::setTotalNumberOfRecords()
     * @uses GetPrepaidAccountSummaryResponseImpl::setPrepaidAccountSummaryDetails()
     * @param int $totalNumberOfRecords
     * @param \StructType\PrepaidAccountSummaryDetails $prepaidAccountSummaryDetails
     */
    public function __construct($totalNumberOfRecords = null, \StructType\PrepaidAccountSummaryDetails $prepaidAccountSummaryDetails = null)
    {
        $this
            ->setTotalNumberOfRecords($totalNumberOfRecords)
            ->setPrepaidAccountSummaryDetails($prepaidAccountSummaryDetails);
    }
    /**
     * Get totalNumberOfRecords value
     * @return int|null
     */
    public function getTotalNumberOfRecords()
    {
        return $this->totalNumberOfRecords;
    }
    /**
     * Set totalNumberOfRecords value
     * @param int $totalNumberOfRecords
     * @return \StructType\GetPrepaidAccountSummaryResponseImpl
     */
    public function setTotalNumberOfRecords($totalNumberOfRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalNumberOfRecords) && !is_numeric($totalNumberOfRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNumberOfRecords)), __LINE__);
        }
        $this->totalNumberOfRecords = $totalNumberOfRecords;
        return $this;
    }
    /**
     * Get prepaidAccountSummaryDetails value
     * @return \StructType\PrepaidAccountSummaryDetails|null
     */
    public function getPrepaidAccountSummaryDetails()
    {
        return $this->prepaidAccountSummaryDetails;
    }
    /**
     * Set prepaidAccountSummaryDetails value
     * @param \StructType\PrepaidAccountSummaryDetails $prepaidAccountSummaryDetails
     * @return \StructType\GetPrepaidAccountSummaryResponseImpl
     */
    public function setPrepaidAccountSummaryDetails(\StructType\PrepaidAccountSummaryDetails $prepaidAccountSummaryDetails = null)
    {
        $this->prepaidAccountSummaryDetails = $prepaidAccountSummaryDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPrepaidAccountSummaryResponseImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
