<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLanguageChoicesRequestImpl StructType
 * Meta informations extracted from the WSDL
 * - type: tns:getLanguageChoicesRequestImpl
 * @subpackage Structs
 */
class GetLanguageChoicesRequestImpl extends AuthenticatedIwsRequestImpl
{
    /**
     * The serviceLanguageType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $serviceLanguageType;
    /**
     * Constructor method for getLanguageChoicesRequestImpl
     * @uses GetLanguageChoicesRequestImpl::setServiceLanguageType()
     * @param string $serviceLanguageType
     */
    public function __construct($serviceLanguageType = null)
    {
        $this
            ->setServiceLanguageType($serviceLanguageType);
    }
    /**
     * Get serviceLanguageType value
     * @return string|null
     */
    public function getServiceLanguageType()
    {
        return $this->serviceLanguageType;
    }
    /**
     * Set serviceLanguageType value
     * @uses \EnumType\ServiceLanguageTypeEnum::valueIsValid()
     * @uses \EnumType\ServiceLanguageTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceLanguageType
     * @return \StructType\GetLanguageChoicesRequestImpl
     */
    public function setServiceLanguageType($serviceLanguageType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ServiceLanguageTypeEnum::valueIsValid($serviceLanguageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $serviceLanguageType, implode(', ', \EnumType\ServiceLanguageTypeEnum::getValidValues())), __LINE__);
        }
        $this->serviceLanguageType = $serviceLanguageType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLanguageChoicesRequestImpl
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
